/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.targets;

import java.io.File;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.targets.ImportTarget;
import omero.api.IUpdatePrx;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.IObject;
import omero.rtypes;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateImportTarget
implements ImportTarget {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String discriminator;
    private String template;
    private String target;

    @Override
    public void init(String target) {
        this.target = target;
        String[] tokens = this.target.split(":", 3);
        if (tokens.length == 2) {
            this.template = tokens[1];
            this.discriminator = "+name";
        } else {
            this.template = tokens[2];
            this.discriminator = tokens[1];
        }
    }

    public String getTemplate() {
        return this.template;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public IObject load(OMEROMetadataStoreClient client2, ImportContainer ic) throws Exception {
        IUpdatePrx update = client2.getServiceFactory().getUpdateService();
        CommentAnnotation ca = new CommentAnnotationI();
        ca.setNs(rtypes.rstring("openmicroscopy.org/omero/import/targetTemplate"));
        ca.setTextValue(rtypes.rstring(this.target));
        File dir = ic.getFile().getParentFile();
        String desc = FilenameUtils.separatorsToUnix((String)dir.toString());
        ca.setDescription(rtypes.rstring(desc));
        ca = (CommentAnnotation)update.saveAndReturnObject(ca);
        this.log.debug("Created annotation {}", (Object)ca.getId().getValue());
        return ca;
    }
}

