/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import Glacier2.SessionControlPrx;
import Ice.ConnectTimeoutException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Current;
import Ice.Identity;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.SocketException;
import Ice.TieBase;
import Ice.Util;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import ome.conditions.SessionException;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import omero.ApiUsageException;
import omero.InternalException;
import omero.ServerError;
import omero.ShutdownInProgress;
import omero.api.ClientCallbackPrx;
import omero.api.ClientCallbackPrxHelper;
import omero.api._StatefulServiceInterfaceOperations;
import omero.cmd.AMD_Session_submit;
import omero.cmd.CallContext;
import omero.cmd.GraphQuery;
import omero.cmd.HandlePrx;
import omero.cmd.HandlePrxHelper;
import omero.cmd.IHandle;
import omero.cmd.IRequest;
import omero.cmd.Request;
import omero.cmd.SessionAware;
import omero.cmd._HandleTie;
import omero.cmd._SessionOperations;
import omero.util.CloseableServant;
import omero.util.IceMapper;
import omero.util.ServantHolder;
import omero.util.TieAware;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class SessionI
implements _SessionOperations {
    private static final Logger log = LoggerFactory.getLogger(SessionI.class);
    public final String clientId;
    public final SessionControlPrx control;
    protected final AtomicBoolean reusedSession;
    protected boolean doClose = true;
    protected ClientCallbackPrx callback;
    public final ServantHolder holder;
    public final SessionManager sessionManager;
    public final Executor executor;
    public final Principal principal;
    public final OmeroContext context;
    public final ObjectAdapter adapter;
    public final String token;

    public SessionI(boolean reusedSession, Current current, ServantHolder holder, SessionControlPrx control, OmeroContext context, SessionManager sessionManager, Executor executor, Principal principal, String token) throws ApiUsageException {
        this.clientId = SessionI.clientId(current);
        this.adapter = current.adapter;
        this.control = control;
        this.sessionManager = sessionManager;
        this.context = context;
        this.executor = executor;
        this.principal = principal;
        this.token = token;
        this.reusedSession = new AtomicBoolean(reusedSession);
        Ehcache cache = sessionManager.inMemoryCache(principal.getName());
        String key = "servantHolder";
        this.holder = holder;
        if (!cache.isKeyInCache((Object)key)) {
            cache.put(new Element((Object)key, (Object)holder));
        } else {
            ServantHolder oldHolder = (ServantHolder)cache.get((Serializable)((Object)key)).getObjectValue();
            assert (oldHolder == holder);
        }
    }

    public ObjectAdapter getAdapter() {
        return this.adapter;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void submit_async(AMD_Session_submit __cb, Request req, Current current) {
        Object priority = req instanceof GraphQuery ? Executor.Priority.BACKGROUND : null;
        this.submit_async(__cb, req, current, (Executor.Priority)priority);
    }

    public void submit_async(AMD_Session_submit __cb, Request req, Current current, Executor.Priority priority) {
        try {
            if (req == null || !IRequest.class.isAssignableFrom(((Object)((Object)req)).getClass())) {
                log.info("Non-IRequest found:" + (Object)((Object)req));
                __cb.ice_response(null);
                return;
            }
            Ice.Object servant = null;
            for (String key : Arrays.asList(req.ice_id(), _HandleTie.ice_staticId())) {
                try {
                    servant = this.createServantDelegate(key);
                    if (servant == null || !(servant instanceof IHandle)) continue;
                    break;
                }
                catch (Exception e) {
                    log.debug(e.getClass().getName() + " on lookup of " + key);
                }
            }
            IHandle handle = null;
            if (servant != null) {
                if (servant instanceof TieBase) {
                    TieBase tie = (TieBase)servant;
                    Object delegate = tie.ice_delegate();
                    if (IHandle.class.isAssignableFrom(delegate.getClass())) {
                        handle = (IHandle)delegate;
                    }
                } else if (servant instanceof IHandle) {
                    handle = (IHandle)servant;
                }
            }
            if (handle == null) {
                log.info("No handle found for " + (Object)((Object)req));
                InternalException ie = new InternalException();
                ie.message = "No handle found for " + (Object)((Object)req);
                __cb.ice_exception((Exception)((Object)ie));
                return;
            }
            Identity id = this.holder.getIdentity("IHandle" + UUID.randomUUID().toString());
            _HandleTie tie = (_HandleTie)servant;
            HandlePrx prx = HandlePrxHelper.checkedCast(this.registerServant(id, tie));
            try {
                handle.initialize(id, (IRequest)((Object)req), current.ctx);
                this.executor.submit(priority, current.ctx, Executors.callable(handle));
                __cb.ice_response(prx);
            }
            catch (Throwable e) {
                log.error("Exception on startup; removing handle " + id, e);
                this.unregisterServant(id);
                throw e;
            }
        }
        catch (Exception e) {
            log.error("Exception on " + (Object)((Object)req));
            __cb.ice_exception(e);
        }
        catch (Throwable t) {
            log.error("Throwable on " + (Object)((Object)req));
            RuntimeException rt = new RuntimeException("Throwable raised on " + (Object)((Object)req));
            rt.initCause(t);
            throw rt;
        }
    }

    public void destroy(Current current) {
        int ref;
        Identity sessionId = this.sessionId();
        log.debug("destroy(" + this + ")");
        try {
            this.adapter.remove(sessionId);
            this.holder.removeClientId(this.clientId);
        }
        catch (NotRegisteredException nre) {
            log.warn("NotRegisteredException: " + Util.identityToString((Identity)this.sessionId()));
        }
        catch (ObjectAdapterDeactivatedException oade) {
            log.warn("Adapter already deactivated. Cannot remove: " + this.sessionId());
        }
        catch (Throwable t) {
            log.error("Can't remove service factory", t);
        }
        try {
            ref = this.sessionManager.detach(this.principal.getName());
        }
        catch (SessionException rse) {
            log.info("Session already removed. Cleaning up blitz state.");
            ref = 0;
            this.doClose = true;
        }
        if (this.doClose && ref < 1) {
            ClientCallbackPrx copy = this.callback;
            this.callback = null;
            if (copy != null) {
                try {
                    ObjectPrx prx = copy.ice_oneway();
                    ClientCallbackPrx oneway = ClientCallbackPrxHelper.uncheckedCast(prx);
                    oneway.sessionClosed();
                }
                catch (Exception e) {
                    this.handleCallbackException(e);
                }
            }
            this.doDestroy();
            try {
                ref = this.sessionManager.close(this.principal.getName());
            }
            catch (SessionException sessionException) {}
        } else {
            this.cleanupSelf();
        }
    }

    public void handleCallbackException(Exception e) {
        if (e instanceof NotRegisteredException) {
            log.warn(this.clientId + "'s callback not registered - perhaps wrong proxy?");
        } else if (e instanceof ConnectionRefusedException) {
            log.warn(this.clientId + "'s callback refused connection - did the client die?");
        } else if (e instanceof ConnectionLostException) {
            log.debug(this.clientId + "'s connection lost as expected");
        } else if (e instanceof ConnectTimeoutException) {
            log.warn("ConnectTimeoutException on callback:" + this.clientId);
        } else if (e instanceof SocketException) {
            log.warn("SocketException on callback: " + this.clientId);
        } else {
            log.error("Unknown error on callback method for client: " + this.clientId, (Throwable)e);
        }
    }

    public void cleanupSelf() {
        if (log.isInfoEnabled()) {
            log.info(String.format("cleanupSelf(%s).", this));
        }
        this.cleanServants(false);
    }

    public void doDestroy() {
        if (log.isInfoEnabled()) {
            log.info(String.format("doDestroy(%s)", this));
        }
        this.cleanServants(true);
    }

    public void cleanServants(boolean all) {
        SessionI.cleanServants(all, this.clientId, this.holder, this.adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanServants(boolean all, String clientId, ServantHolder holder, ObjectAdapter adapter) {
        holder.acquireLock("*");
        try {
            List<String> servants = holder.getServantList();
            for (String idName : servants) {
                Identity id = holder.getIdentity(idName);
                Object servant = holder.getUntied(id);
                if (servant == null) {
                    log.warn("Servant already removed: " + idName);
                    SessionI.unregisterServant(id, adapter, holder);
                    continue;
                }
                if (!all) {
                    if (!idName.contains(clientId)) continue;
                    if (servant instanceof _StatefulServiceInterfaceOperations) {
                        log.info("Leaving StatefulService alive:" + idName);
                        continue;
                    }
                }
                try {
                    if (!(servant instanceof CloseableServant)) continue;
                    CloseableServant cs = (CloseableServant)servant;
                    cs.close(SessionI.newCurrent(id, "close", adapter, clientId));
                }
                catch (Exception e) {
                    log.error("Error destroying servant: " + idName + "=" + servant, (Throwable)e);
                }
                finally {
                    SessionI.unregisterServant(id, adapter, holder);
                    log.info("Removed servant from adapter: " + idName);
                }
            }
        }
        finally {
            holder.releaseLock("*");
        }
    }

    protected void internalServantConfig(Object obj) throws ServerError {
        if (obj instanceof SessionAware) {
            ((SessionAware)obj).setSession(this);
        }
    }

    public static Current newCurrent(Identity id, String method, ObjectAdapter adapter, String clientId) {
        Current __curr = new Current();
        __curr.id = id;
        __curr.adapter = adapter;
        __curr.operation = method;
        __curr.ctx = new HashMap();
        __curr.ctx.put("omero.client.uuid", clientId);
        return __curr;
    }

    public Current newCurrent(Identity id, String method) {
        return SessionI.newCurrent(id, method, this.adapter, this.clientId);
    }

    public void allow(ObjectPrx prx) {
        if (prx != null && this.control != null) {
            this.control.identities().add(new Identity[]{prx.ice_getIdentity()});
        }
    }

    protected Ice.Object createServantDelegate(String name) throws ServerError {
        Ice.Object servant = null;
        try {
            servant = (Ice.Object)this.context.getBean(name);
            this.configureServant(servant);
            return servant;
        }
        catch (ClassCastException cce) {
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, cce);
            ie.message = "Could not cast to Ice.Object:[" + name + "]";
            throw ie;
        }
        catch (NoSuchBeanDefinitionException nosuch) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = name + " is an unknown service. Please check Constants.ice or the documentation for valid strings.";
            throw aue;
        }
        catch (Exception e) {
            log.warn("Uncaught exception in createServantDelegate. ", (Throwable)e);
            throw new InternalException(null, e.getClass().getName(), e.getMessage());
        }
    }

    public void configureServant(Ice.Object servant) throws ServerError {
        this.internalServantConfig(servant);
        Object real = servant;
        if (servant instanceof TieBase) {
            TieBase tie = (TieBase)servant;
            real = tie.ice_delegate();
            this.internalServantConfig(real);
            if (real instanceof TieAware) {
                ((TieAware)real).setTie(tie);
            }
        }
    }

    public ObjectPrx registerServant(Identity id, Ice.Object servant) throws ServerError {
        return this.registerServant(id, servant, null);
    }

    public ObjectPrx registerServant(Identity id, Ice.Object servant, Current current) throws ServerError {
        ObjectPrx prx;
        block6: {
            prx = null;
            try {
                servant = this.callContextWrapper(servant, current);
                Ice.Object already = this.adapter.find(id);
                if (null == already) {
                    this.adapter.add(servant, id);
                    prx = this.adapter.createDirectProxy(id);
                    if (log.isInfoEnabled()) {
                        log.info("Added servant to adapter: " + SessionI.servantString(id, servant));
                    }
                    break block6;
                }
                throw new InternalException(null, null, "Servant already registered: " + SessionI.servantString(id, servant));
            }
            catch (Exception e) {
                if (e instanceof InternalException) {
                    throw (InternalException)((Object)e);
                }
                if (e instanceof ObjectAdapterDeactivatedException) {
                    ShutdownInProgress sip = new ShutdownInProgress(null, null, "ObjectAdapter deactivated");
                    IceMapper.fillServerError(sip, e);
                    throw sip;
                }
                InternalException ie = new InternalException();
                IceMapper.fillServerError(ie, e);
                throw ie;
            }
        }
        this.holder.put(id, servant);
        return prx;
    }

    protected Ice.Object callContextWrapper(Ice.Object servant, Current current) {
        if (!TieBase.class.isAssignableFrom(servant.getClass())) {
            return servant;
        }
        TieBase tie = (TieBase)servant;
        Object delegate = tie.ice_delegate();
        ProxyFactory wrapper = new ProxyFactory(delegate);
        wrapper.addAdvice(0, (Advice)new CallContext(this.context, this.token, current));
        tie.ice_delegate(wrapper.getProxy());
        return servant;
    }

    public void unregisterServant(Identity id) {
        SessionI.unregisterServant(id, this.adapter, this.holder);
    }

    public static void unregisterServant(Identity id, ObjectAdapter adapter, ServantHolder holder) {
        if (null == adapter.find(id)) {
            return;
        }
        Ice.Object obj = adapter.remove(id);
        String str = SessionI.servantString(id, obj);
        if (holder == null) {
            log.warn("Holder is null for " + str);
        } else {
            Ice.Object removed = holder.remove(id);
            if (removed == null) {
                log.error("Adapter and active servants out of sync.");
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Unregistered servant:" + str);
        }
    }

    private static String servantString(Identity id, Object obj) {
        StringBuilder sb = new StringBuilder(Util.identityToString((Identity)id));
        sb.append("(");
        sb.append(obj);
        sb.append(")");
        return sb.toString();
    }

    public Identity getIdentity(String name) {
        return this.holder.getIdentity(name);
    }

    public static Identity sessionId(String clientId, String uuid) {
        Identity id = new Identity();
        id.category = "session-" + clientId;
        id.name = uuid;
        return id;
    }

    public Identity sessionId() {
        return SessionI.sessionId(this.clientId, this.principal.getName());
    }

    public static String clientId(Current current) throws ApiUsageException {
        String clientId = null;
        if (current.ctx != null) {
            clientId = (String)current.ctx.get("omero.client.uuid");
        }
        if (clientId == null) {
            throw new ApiUsageException(null, null, "No omero.client.uuid key provided in context.");
        }
        return clientId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(Util.identityToString((Identity)this.sessionId()));
        sb.append(")");
        return sb.toString();
    }
}

