/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.api.IQuery;
import ome.io.bioformats.BfPixelBuffer;
import ome.io.bioformats.BfPixelsWrapper;
import ome.io.bioformats.BfPyramidPixelBuffer;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.parameters.Parameters;
import ome.services.util.ReadOnlyStatus;
import omero.cmd.ERR;
import omero.cmd.FindPyramids;
import omero.cmd.FindPyramidsResponse;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPyramidsI
extends FindPyramids
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final long serialVersionUID = -1L;
    private final FindPyramidsResponse rsp = new FindPyramidsResponse();
    private static Logger log = LoggerFactory.getLogger(FindPyramidsI.class);
    private List<Long> imageIds = new ArrayList<Long>();
    private final PixelsService pixelsService;
    private Helper helper;
    private IQuery service;
    private String query;
    private File pixeldsDir;

    public FindPyramidsI(PixelsService pixelsService) {
        this.pixelsService = pixelsService;
        this.pixeldsDir = new File(pixelsService.getPixelsDirectory());
    }

    @Override
    public Map<String, String> getCallContext() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.put("omero.group", "-1");
        return all;
    }

    @Override
    public void init(Helper helper) throws HandleI.Cancel {
        this.helper = helper;
        this.service = helper.getServiceFactory().getQueryService();
        helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        switch (step) {
            case 0: {
                this.findPyramids();
                break;
            }
            default: {
                throw this.helper.cancel(new ERR(), null, "unknown-step", "step", "" + step);
            }
        }
        return null;
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            this.helper.setResponseIfNull(this.rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private void findPyramids() {
        StringBuilder sb = new StringBuilder();
        sb.append("select p from Pixels as p ");
        sb.append("left outer join fetch p.image as i ");
        sb.append("left outer join fetch i.details.creationEvent ");
        sb.append("where p.id = :id");
        this.query = sb.toString();
        this.walkDirectory(this.pixeldsDir);
        this.rsp.pyramidFiles = this.imageIds;
    }

    private void walkDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String[] values;
            long id;
            if ((long)this.imageIds.size() >= this.limit) break;
            if (file.isDirectory()) {
                this.walkDirectory(file);
                continue;
            }
            String name = file.getName();
            if (!name.endsWith("_pyramid")) continue;
            boolean toFind = true;
            if (this.checkEmptyFile && file.length() == 0L) {
                File[] list;
                for (File lockfile : list = this.pixeldsDir.listFiles()) {
                    String n = lockfile.getName();
                    if (!n.startsWith("." + name) || !n.endsWith(".tmp") && !n.endsWith(".pyr_lock")) continue;
                    toFind = false;
                    break;
                }
            }
            if (!toFind || (id = this.getImage(Long.parseLong((values = name.split("_"))[0]))) < 0L) continue;
            this.imageIds.add(id);
        }
    }

    private long getImage(long pixelsId) {
        Pixels pixels = (Pixels)this.service.findByQuery(this.query, new Parameters().addId(Long.valueOf(pixelsId)));
        if (pixels == null) {
            return -1L;
        }
        Image image = pixels.getImage();
        if (this.checkEmptyFile) {
            return image.getId();
        }
        long creation = image.getDetails().getCreationEvent().getTime().getTime();
        long time = -1L;
        if (this.importedAfter != null) {
            time = this.importedAfter.getValue();
        }
        if (time < creation && (this.littleEndian == null || this.isLittleEndian(pixels) == this.littleEndian.getValue())) {
            return image.getId();
        }
        return -1L;
    }

    private boolean isLittleEndian(Pixels pixels) {
        try {
            PixelBuffer pf = this.pixelsService._getPixelBuffer(pixels, false);
            if (pf instanceof BfPixelsWrapper) {
                return ((BfPixelsWrapper)pf).isLittleEndian();
            }
            if (pf instanceof BfPyramidPixelBuffer) {
                return ((BfPyramidPixelBuffer)pf).isLittleEndian();
            }
            if (pf instanceof BfPixelBuffer) {
                return ((BfPixelBuffer)pf).isLittleEndian();
            }
        }
        catch (Exception e) {
            log.debug("Error instantiating pixel buffer", (Throwable)e);
        }
        return false;
    }

    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return true;
    }
}

