/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public class PrefixSubstituter<X extends Comparable<X>> {
    private final BiFunction<X, X, X> addPrefix;
    private final BiFunction<X, X, X> delPrefix;
    private final SortedMap<X, Map.Entry<X, X>> lookup;

    public PrefixSubstituter(final BiPredicate<X, X> isPrefixOf, BiFunction<X, X, X> addPrefix, BiFunction<X, X, X> delPrefix) {
        this.addPrefix = addPrefix;
        this.delPrefix = delPrefix;
        this.lookup = new TreeMap<X, Map.Entry<X, X>>(new Comparator<X>(){

            @Override
            public int compare(X p, X q) {
                if (isPrefixOf.test(p, q) || isPrefixOf.test(q, p)) {
                    return 0;
                }
                return p.compareTo(q);
            }
        });
    }

    public void put(X from, X to) {
        if (this.lookup.put(from, Maps.immutableEntry(from, to)) != null) {
            throw new IllegalArgumentException("can add only prefixes that are not a prefix of another");
        }
    }

    public X apply(X item) {
        Map.Entry substitution = (Map.Entry)this.lookup.get(item);
        if (substitution == null) {
            return item;
        }
        Comparable prefixFrom = (Comparable)substitution.getKey();
        Comparable prefixTo = (Comparable)substitution.getValue();
        Comparable suffix = (Comparable)this.delPrefix.apply(prefixFrom, item);
        return (X)((Comparable)this.addPrefix.apply(prefixTo, suffix));
    }
}

