/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resources {
    private static Logger log = LoggerFactory.getLogger((String)Resources.class.getName());
    private final int sleeptime;
    private final ScheduledFuture<?> future;
    private final ScheduledExecutorService service;
    private final List<Entry> stuff = new CopyOnWriteArrayList<Entry>();

    public Resources() {
        this(60);
    }

    public Resources(int sleeptimeSeconds) {
        this(sleeptimeSeconds, Executors.newSingleThreadScheduledExecutor());
    }

    public Resources(int sleeptimeSeconds, ScheduledExecutorService service) {
        this.sleeptime = sleeptimeSeconds;
        this.service = service;
        log.trace("Starting");
        this.future = this.service.scheduleAtFixedRate(this.task(), 1L, this.sleeptime, TimeUnit.SECONDS);
    }

    private Runnable task() {
        return new Runnable(){

            @Override
            public void run() {
                log.trace("Running checks...");
                for (Entry entry : Resources.this.stuff) {
                    log.trace("Checking " + entry);
                    boolean success = true;
                    try {
                        success = entry.check();
                    }
                    catch (Exception e) {
                        log.warn("Exception thrown by entry: " + e.getMessage());
                        success = false;
                    }
                    if (success) continue;
                    Resources.this.remove(entry);
                }
                log.trace("Finished checks.");
            }
        };
    }

    public void add(Entry entry) {
        if (entry == null) {
            log.warn("Entry null");
            return;
        }
        log.trace("Adding object " + entry);
        this.stuff.add(entry);
    }

    public int size() {
        return this.stuff.size();
    }

    public void cleanup() {
        log.trace("Cleaning called");
        for (Entry entry : this.stuff) {
            this.remove(entry);
        }
        log.trace("Stopping");
        this.future.cancel(false);
        log.trace("Stopped");
    }

    public void remove(Entry entry) {
        if (entry == null) {
            log.warn("Entry null");
            return;
        }
        log.trace("Cleaning " + entry);
        try {
            entry.cleanup();
        }
        catch (Exception e) {
            log.warn("Cleaning entry threw an exception" + e);
        }
        log.trace("Removing " + entry);
        this.stuff.remove(entry);
    }

    public static interface Entry {
        public boolean check();

        public void cleanup();
    }
}

