/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.units.Length;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="transmittancerange_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="transmittancerange_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="transmittancerange_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="transmittancerange_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="transmittancerange_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="transmittancerange_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="transmittancerange_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="transmittancerange_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT filter.transmittancerange FROM filter*, image* WHERE filter.instrument = image.instrument AND image.id IN (:images)))")})
@Entity
@Table(name="transmittancerange", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_transmittancerange", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_transmittancerange"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class TransmittanceRange
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "transmittancerange_owner_filter";
    public static final String GROUP_FILTER = "transmittancerange_group_filter";
    public static final String EVENT_FILTER = "transmittancerange_event_filter";
    public static final String PERMS_FILTER = "transmittancerange_perms_filter";
    public static final String ID = "ome.model.acquisition.TransmittanceRange_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.TransmittanceRange_version";
    protected Integer version = 0;
    protected Length cutIn = null;
    protected Length cutOut = null;
    protected Length cutInTolerance = null;
    protected Length cutOutTolerance = null;
    protected Double transmittance = null;
    protected ome.model.internal.Details details = new Details();
    public static final String CUTIN = "ome.model.acquisition.TransmittanceRange_cutIn";
    public static final String CUTOUT = "ome.model.acquisition.TransmittanceRange_cutOut";
    public static final String CUTINTOLERANCE = "ome.model.acquisition.TransmittanceRange_cutInTolerance";
    public static final String CUTOUTTOLERANCE = "ome.model.acquisition.TransmittanceRange_cutOutTolerance";
    public static final String TRANSMITTANCE = "ome.model.acquisition.TransmittanceRange_transmittance";
    public static final String DETAILS = "ome.model.acquisition.TransmittanceRange_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public TransmittanceRange() {
        this(null, true);
    }

    protected TransmittanceRange(Long id) {
        this(id, true);
    }

    public TransmittanceRange(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_transmittancerange")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="cutIn")), @AttributeOverride(name="unit", column=@Column(name="cutInUnit"))})
    public Length getCutIn() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cutIn;
    }

    public void setCutIn(Length cutIn) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (cutIn != null && cutIn.getValue() <= 0.0) {
            throw new IllegalArgumentException("values of TransmittanceRange.cutIn must be strictly positive");
        }
        this.cutIn = cutIn;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="cutOut")), @AttributeOverride(name="unit", column=@Column(name="cutOutUnit"))})
    public Length getCutOut() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cutOut;
    }

    public void setCutOut(Length cutOut) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (cutOut != null && cutOut.getValue() <= 0.0) {
            throw new IllegalArgumentException("values of TransmittanceRange.cutOut must be strictly positive");
        }
        this.cutOut = cutOut;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="cutInTolerance")), @AttributeOverride(name="unit", column=@Column(name="cutInToleranceUnit"))})
    public Length getCutInTolerance() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cutInTolerance;
    }

    public void setCutInTolerance(Length cutInTolerance) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (cutInTolerance != null && cutInTolerance.getValue() < 0.0) {
            throw new IllegalArgumentException("values of TransmittanceRange.cutInTolerance must not be negative");
        }
        this.cutInTolerance = cutInTolerance;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="cutOutTolerance")), @AttributeOverride(name="unit", column=@Column(name="cutOutToleranceUnit"))})
    public Length getCutOutTolerance() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cutOutTolerance;
    }

    public void setCutOutTolerance(Length cutOutTolerance) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (cutOutTolerance != null && cutOutTolerance.getValue() < 0.0) {
            throw new IllegalArgumentException("values of TransmittanceRange.cutOutTolerance must not be negative");
        }
        this.cutOutTolerance = cutOutTolerance;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="percent_fraction", nullable=true, unique=false, name="transmittance", updatable=true)
    public Double getTransmittance() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.transmittance;
    }

    public void setTransmittance(Double transmittance) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (transmittance != null && (transmittance < 0.0 || transmittance > 1.0)) {
            throw new IllegalArgumentException("values of TransmittanceRange.transmittance may range from zero to one only");
        }
        this.transmittance = transmittance;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public TransmittanceRange newInstance() {
        return new TransmittanceRange();
    }

    public TransmittanceRange proxy() {
        return new TransmittanceRange(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.cutIn = (Length)__filter.filter(CUTIN, this.cutIn);
            this.cutOut = (Length)__filter.filter(CUTOUT, this.cutOut);
            this.cutInTolerance = (Length)__filter.filter(CUTINTOLERANCE, this.cutInTolerance);
            this.cutOutTolerance = (Length)__filter.filter(CUTOUTTOLERANCE, this.cutOutTolerance);
            this.transmittance = (Double)__filter.filter(TRANSMITTANCE, this.transmittance);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(CUTIN)) {
            return this.getCutIn();
        }
        if (field.equals(CUTOUT)) {
            return this.getCutOut();
        }
        if (field.equals(CUTINTOLERANCE)) {
            return this.getCutInTolerance();
        }
        if (field.equals(CUTOUTTOLERANCE)) {
            return this.getCutOutTolerance();
        }
        if (field.equals(TRANSMITTANCE)) {
            return this.getTransmittance();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(CUTIN)) {
            this.setCutIn((Length)value);
        } else if (field.equals(CUTOUT)) {
            this.setCutOut((Length)value);
        } else if (field.equals(CUTINTOLERANCE)) {
            this.setCutInTolerance((Length)value);
        } else if (field.equals(CUTOUTTOLERANCE)) {
            this.setCutOutTolerance((Length)value);
        } else if (field.equals(TRANSMITTANCE)) {
            this.setTransmittance((Double)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.cutIn = null;
        this.cutOut = null;
        this.cutInTolerance = null;
        this.cutOutTolerance = null;
        this.transmittance = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(CUTIN);
        raw.add(CUTOUT);
        raw.add(CUTINTOLERANCE);
        raw.add(CUTOUTTOLERANCE);
        raw.add(TRANSMITTANCE);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKtransmittancerange_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKtransmittancerange_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKtransmittancerange_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKtransmittancerange_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKtransmittancerange_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

