/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import javax.transaction.Synchronization;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalWorker
implements Worker {
    private static final Logger log = LoggerFactory.make();
    protected final WeakIdentityHashMap<Object, Synchronization> synchronizationPerTransaction = new WeakIdentityHashMap();
    private QueueingProcessor queueingProcessor;
    private SearchFactoryImplementor factory;

    @Override
    public void performWork(Work<?> work, TransactionContext transactionContext) {
        Class<?> entityType = HibernateHelper.getClassFromWork(work);
        if (this.factory.getDocumentBuilderIndexedEntity(entityType) == null && this.factory.getDocumentBuilderContainedEntity(entityType) == null) {
            throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + entityType);
        }
        if (transactionContext.isTransactionInProgress()) {
            Object transactionIdentifier = transactionContext.getTransactionIdentifier();
            PostTransactionWorkQueueSynchronization txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transactionIdentifier);
            if (txSync == null || txSync.isConsumed()) {
                txSync = new PostTransactionWorkQueueSynchronization(this.queueingProcessor, this.synchronizationPerTransaction, this.factory);
                transactionContext.registerSynchronization(txSync);
                this.synchronizationPerTransaction.put(transactionIdentifier, txSync);
            }
            txSync.add(work);
        } else {
            log.warn("It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!");
            WorkQueue queue = new WorkQueue(this.factory);
            this.queueingProcessor.add(work, queue);
            this.queueingProcessor.prepareWorks(queue);
            this.queueingProcessor.performWorks(queue);
        }
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context) {
        this.queueingProcessor = new BatchedQueueingProcessor(context, props);
        this.factory = context.getUninitializedSearchFactory();
    }

    @Override
    public void close() {
        this.queueingProcessor.close();
    }

    @Override
    public void flushWorks(TransactionContext transactionContext) {
        Object transaction;
        PostTransactionWorkQueueSynchronization txSync;
        if (transactionContext.isTransactionInProgress() && (txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transaction = transactionContext.getTransactionIdentifier())) != null && !txSync.isConsumed()) {
            txSync.flushWorks();
        }
    }
}

