/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.HibernateSearchResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SolrAnalyzerBuilder {
    private static final String SOLR_LUCENE_VERSION_PARAM = "luceneMatchVersion";

    private SolrAnalyzerBuilder() {
    }

    public static Analyzer buildAnalyzer(AnalyzerDef analyzerDef, Version luceneMatchVersion) {
        Map<String, String> mapOfParameters;
        int index;
        HibernateSearchResourceLoader defaultResourceLoader = new HibernateSearchResourceLoader();
        TokenizerDef token = analyzerDef.tokenizer();
        TokenizerFactory tokenFactory = ClassLoaderHelper.instanceFromClass(TokenizerFactory.class, token.factory(), "Tokenizer factory");
        Map<String, String> tokenMapsOfParameters = SolrAnalyzerBuilder.getMapOfParameters(token.params(), luceneMatchVersion);
        tokenFactory.init(tokenMapsOfParameters);
        SolrAnalyzerBuilder.injectResourceLoader(tokenFactory, defaultResourceLoader, tokenMapsOfParameters);
        int length = analyzerDef.filters().length;
        int charLength = analyzerDef.charFilters().length;
        TokenFilterFactory[] filters = new TokenFilterFactory[length];
        CharFilterFactory[] charFilters = new CharFilterFactory[charLength];
        for (index = 0; index < length; ++index) {
            TokenFilterDef filterDef = analyzerDef.filters()[index];
            filters[index] = ClassLoaderHelper.instanceFromClass(TokenFilterFactory.class, filterDef.factory(), "Token filter factory");
            mapOfParameters = SolrAnalyzerBuilder.getMapOfParameters(filterDef.params(), luceneMatchVersion);
            filters[index].init(mapOfParameters);
            SolrAnalyzerBuilder.injectResourceLoader(filters[index], defaultResourceLoader, mapOfParameters);
        }
        for (index = 0; index < charFilters.length; ++index) {
            CharFilterDef charFilterDef = analyzerDef.charFilters()[index];
            charFilters[index] = ClassLoaderHelper.instanceFromClass(CharFilterFactory.class, charFilterDef.factory(), "Character filter factory");
            mapOfParameters = SolrAnalyzerBuilder.getMapOfParameters(charFilterDef.params(), luceneMatchVersion);
            charFilters[index].init(mapOfParameters);
            SolrAnalyzerBuilder.injectResourceLoader(charFilters[index], defaultResourceLoader, mapOfParameters);
        }
        return new TokenizerChain(charFilters, tokenFactory, filters);
    }

    private static void injectResourceLoader(Object processor, ResourceLoader defaultResourceLoader, Map<String, String> mapOfParameters) {
        if (processor instanceof ResourceLoaderAware) {
            String charset = mapOfParameters.get("resource_charset");
            ResourceLoader localResourceLoader = charset != null ? new HibernateSearchResourceLoader(charset) : defaultResourceLoader;
            ((ResourceLoaderAware)processor).inform(localResourceLoader);
        }
    }

    private static Map<String, String> getMapOfParameters(Parameter[] params, Version luceneMatchVersion) {
        HashMap<String, String> mapOfParams = new HashMap<String, String>(params.length);
        for (Parameter param : params) {
            mapOfParams.put(param.name(), param.value());
        }
        mapOfParams.put(SOLR_LUCENE_VERSION_PARAM, luceneMatchVersion.toString());
        return Collections.unmodifiableMap(mapOfParams);
    }
}

