/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

public final class MemoryMappedFile
extends NativeMemory {
    private RandomAccessFile randomAccessFile_ = null;
    private MappedByteBuffer dummyMbbInstance_ = null;
    private final Cleaner cleaner_;

    private MemoryMappedFile(RandomAccessFile raf, MappedByteBuffer mbb, long nativeBaseAddress, long capacityBytes) {
        super(nativeBaseAddress, capacityBytes, 0L, null, null);
        this.randomAccessFile_ = raf;
        this.dummyMbbInstance_ = mbb;
        this.cleaner_ = Cleaner.create((Object)this, (Runnable)new Deallocator(this.randomAccessFile_, nativeBaseAddress, capacityBytes));
    }

    public static MemoryMappedFile getInstance(File file, long position, long len) throws Exception {
        MemoryMappedFile.checkPositionLen(position, len);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        long nativeBaseAddress = MemoryMappedFile.map(fc, position, len);
        long capacityBytes = len;
        raf.setLength(len);
        MappedByteBuffer mbb = MemoryMappedFile.createDummyMbbInstance(nativeBaseAddress);
        return new MemoryMappedFile(raf, mbb, nativeBaseAddress, capacityBytes);
    }

    private static final void checkPositionLen(long position, long len) {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (position + len < 0L) {
            throw new IllegalArgumentException("Position + size overflow");
        }
    }

    public void load() {
        this.madvise();
        int ps = UnsafeUtil.unsafe.pageSize();
        int count = MemoryMappedFile.pageCount(ps, this.capacityBytes_);
        long a = this.nativeBaseAddress_;
        for (int i = 0; i < count; ++i) {
            UnsafeUtil.unsafe.getByte(a);
            a += (long)ps;
        }
    }

    public boolean isLoaded() {
        try {
            int ps = UnsafeUtil.unsafe.pageSize();
            int pageCount = MemoryMappedFile.pageCount(ps, this.capacityBytes_);
            Method method = MappedByteBuffer.class.getDeclaredMethod("isLoaded0", Long.TYPE, Long.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)this.dummyMbbInstance_, this.nativeBaseAddress_, this.capacityBytes_, pageCount);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    public void force() {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.dummyMbbInstance_, this.randomAccessFile_.getFD(), this.nativeBaseAddress_, this.capacityBytes_);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception in force", e.getClass()));
        }
    }

    @Override
    public void freeMemory() {
        this.cleaner_.clean();
        super.freeMemory();
    }

    static final int pageCount(int ps, long length) {
        return (int)(length == 0L ? 0L : (length - 1L) / (long)ps + 1L);
    }

    private static final MappedByteBuffer createDummyMbbInstance(long nativeBaseAddress) throws RuntimeException {
        try {
            Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
            ctor.setAccessible(true);
            MappedByteBuffer mbb = (MappedByteBuffer)ctor.newInstance(0, nativeBaseAddress, null, null);
            return mbb;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Dummy MappedByteBuffer instance: " + e.getClass());
        }
    }

    private void madvise() throws RuntimeException {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("load0", Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.dummyMbbInstance_, this.nativeBaseAddress_, this.capacityBytes_);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    private static final long map(FileChannel fileChannel, long position, long len) throws RuntimeException {
        int pagePosition = (int)(position % (long)UnsafeUtil.unsafe.pageSize());
        long mapPosition = position - (long)pagePosition;
        long mapSize = len + (long)pagePosition;
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            long addr = (Long)method.invoke((Object)fileChannel, 1, mapPosition, mapSize);
            return addr;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while mapping", e.getClass()));
        }
    }

    private static final class Deallocator
    implements Runnable {
        private RandomAccessFile raf;
        private FileChannel fc;
        private long nativeBaseAdd;
        private long capBytes;

        private Deallocator(RandomAccessFile randomAccessFile, long nativeBaseAddress, long capacityBytes) {
            assert (randomAccessFile != null);
            assert (nativeBaseAddress != 0L);
            assert (capacityBytes != 0L);
            this.raf = randomAccessFile;
            this.fc = randomAccessFile.getChannel();
            this.nativeBaseAdd = nativeBaseAddress;
            this.capBytes = capacityBytes;
        }

        private void unmap() throws RuntimeException {
            try {
                Method method = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.fc, this.nativeBaseAdd, this.capBytes);
                this.raf.close();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Encountered %s exception while freeing memory", e.getClass()));
            }
        }

        @Override
        public void run() {
            if (this.fc != null) {
                this.unmap();
            }
            this.nativeBaseAdd = 0L;
        }
    }
}

