/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Util;
import java.io.File;
import java.nio.channels.OverlappingFileLockException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import ome.model.IObject;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.FileMaker;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.blitz.repo.RawAccessRequestI;
import ome.services.blitz.repo.RepositoryDao;
import ome.services.messages.DeleteLogMessage;
import ome.services.messages.DeleteLogsMessage;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import ome.util.messages.InternalMessage;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.cmd.ERR;
import omero.cmd.OK;
import omero.cmd.Response;
import omero.grid.FileDeleteException;
import omero.grid.InternalRepositoryPrx;
import omero.grid.RawAccessRequest;
import omero.grid.RepositoryPrx;
import omero.grid.RepositoryPrxHelper;
import omero.grid._InternalRepositoryDisp;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.util.IceMapper;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRepositoryI
extends _InternalRepositoryDisp
implements ApplicationListener<InternalMessage> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRepositoryI.class);
    private final ObjectAdapter oa;
    private final Registry reg;
    private final Executor ex;
    private final Principal p;
    private final FileMaker fileMaker;
    private final ReadOnlyStatus readOnly;
    private final PublicRepositoryI servant;
    private OriginalFile description;
    private RepositoryPrx proxy;
    private String repoUuid;
    private volatile AtomicReference<State> state = new AtomicReference();

    @Deprecated
    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, String repoDir, PublicRepositoryI servant) {
        this(oa, reg, ex, p, repoDir, new ReadOnlyStatus(false, false), servant);
        log.info("assuming read-write repository");
    }

    @Deprecated
    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, FileMaker fileMaker, PublicRepositoryI servant) {
        this(oa, reg, ex, p, fileMaker, new ReadOnlyStatus(false, false), servant);
        log.info("assuming read-write repository");
    }

    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, String repoDir, ReadOnlyStatus readOnly, PublicRepositoryI servant) {
        this(oa, reg, ex, p, new FileMaker(repoDir), readOnly, servant);
    }

    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, FileMaker fileMaker, ReadOnlyStatus readOnly, PublicRepositoryI servant) {
        this.state.set(State.EAGER);
        this.p = p;
        this.oa = oa;
        this.ex = ex;
        this.reg = reg;
        this.fileMaker = fileMaker;
        this.readOnly = readOnly;
        this.servant = servant;
        log.info("Initializing repository in " + fileMaker.getDir());
    }

    public String generateRepoUuid() {
        return UUID.randomUUID().toString();
    }

    public void onApplicationEvent(InternalMessage im) {
        if (im instanceof DeleteLogMessage) {
            this.handleDLMs(Arrays.asList((DeleteLogMessage)im));
        } else if (im instanceof DeleteLogsMessage) {
            this.handleDLMs(((DeleteLogsMessage)im).getMessages());
        }
    }

    private void handleDLMs(List<DeleteLogMessage> dlms) {
        Current rootCurrent = new Current();
        rootCurrent.ctx = new HashMap();
        rootCurrent.ctx.put("omero.session.uuid", this.p.toString());
        RepositoryDao dao = this.servant.repositoryDao;
        ArrayList<SqlAction.DeleteLog> templates = new ArrayList<SqlAction.DeleteLog>();
        for (DeleteLogMessage dlm : dlms) {
            SqlAction.DeleteLog template = new SqlAction.DeleteLog();
            template.repo = this.repoUuid;
            template.fileId = dlm.getFileId();
            templates.add(template);
        }
        List<List<SqlAction.DeleteLog>> logs = dao.findRepoDeleteLogs(templates, rootCurrent);
        HashMap<SqlAction.DeleteLog, Integer> successes = new HashMap<SqlAction.DeleteLog, Integer>();
        for (int i = 0; i < dlms.size(); ++i) {
            DeleteLogMessage dlm = dlms.get(i);
            List<SqlAction.DeleteLog> dls = logs.get(i);
            for (SqlAction.DeleteLog dl : dls) {
                String filename = dl.path + "/" + dl.name;
                if (filename.startsWith("/")) {
                    filename = "." + filename;
                }
                try {
                    CheckedPath checked = this.servant.checkPath(filename, null, null);
                    if (checked.delete()) {
                        log.debug("DELETED: {}", (Object)checked);
                    } else {
                        FileDeleteException t = new FileDeleteException(null, null, "Delete file failed: " + filename);
                        dlm.error(dl, (Throwable)((Object)t));
                    }
                }
                catch (Throwable t) {
                    log.warn("Failed to delete log " + dl, t);
                    dlm.error(dl, t);
                }
                if (dlm.isError(dl)) continue;
                successes.put(dl, i);
            }
        }
        ArrayList<SqlAction.DeleteLog> copies = new ArrayList<SqlAction.DeleteLog>(successes.keySet());
        List<Integer> counts = dao.deleteRepoDeleteLogs(copies, rootCurrent);
        for (int i = 0; i < copies.size(); ++i) {
            SqlAction.DeleteLog copy = (SqlAction.DeleteLog)copies.get(i);
            Integer index = (Integer)successes.get(copy);
            DeleteLogMessage dlm = dlms.get(index);
            int expected = logs.get(index).size();
            int actual = counts.get(i);
            if (actual != expected) {
                log.warn(String.format("Failed to remove all delete log entries: %s instead of %s", actual, expected));
            }
            dlm.success(copy);
        }
    }

    public boolean takeover() {
        if (!this.state.compareAndSet(State.EAGER, State.WAITING)) {
            log.debug("Skipping takeover: EAGER / WAITING");
            return false;
        }
        Object rv = null;
        try {
            GetOrCreateRepo gorc = this.readOnly.isReadOnlyDb() ? new GetOrCreateRepo(this, "takeover (ro)"){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return this.innerWork(sf);
                }
            } : new GetOrCreateRepo(this, "takeover (rw)"){

                @Transactional(readOnly=false)
                public Object doWork(Session session, ServiceFactory sf) {
                    return this.innerWork(sf);
                }
            };
            rv = this.ex.execute(this.p, (Executor.Work)gorc);
            if (rv instanceof ome.model.core.OriginalFile) {
                ome.model.core.OriginalFile r = (ome.model.core.OriginalFile)rv;
                this.description = this.getDescription(r.getId());
                this.proxy = gorc.publicPrx;
                if (!this.state.compareAndSet(State.WAITING, State.ACTIVE)) {
                    log.debug("Could not set state to ACTIVE");
                }
                return true;
            }
            if (rv instanceof Exception) {
                log.error("Failed during repository takeover", (Throwable)((Exception)rv));
            } else {
                log.error("Unknown issue with repository takeover:" + rv);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error in called executor on takeover", (Throwable)e);
        }
        this.state.compareAndSet(State.WAITING, State.EAGER);
        return false;
    }

    public void close() {
        this.state.set(State.CLOSED);
        log.info("Releasing " + this.fileMaker.getDir());
        this.fileMaker.close();
    }

    public final String getRepoUuid() {
        return this.repoUuid;
    }

    public final Communicator getCommunicator() {
        return this.oa.getCommunicator();
    }

    public final ObjectAdapter getObjectAdapter() {
        return this.oa;
    }

    @Override
    public final OriginalFile getDescription(Current __current) {
        return this.description;
    }

    @Override
    public final RepositoryPrx getProxy(Current __current) {
        return this.proxy;
    }

    @Override
    public Response rawAccess(RawAccessRequest req, Current __current) throws ServerError {
        if (!(req instanceof RawAccessRequestI)) {
            return new ERR();
        }
        try {
            ((RawAccessRequestI)req).local(this, this.servant, __current);
            return new OK();
        }
        catch (Throwable t) {
            throw new IceMapper().handleServerError(t, this.servant.context);
        }
    }

    @Override
    public abstract String getFilePath(OriginalFile var1, Current var2) throws ServerError;

    @Override
    public RawFileStorePrx createRawFileStore(OriginalFile file, Current __current) {
        return null;
    }

    @Override
    public RawPixelsStorePrx createRawPixelsStore(OriginalFile file, Current __current) {
        return null;
    }

    @Override
    public RenderingEnginePrx createRenderingEngine(OriginalFile file, Current __current) {
        return null;
    }

    @Override
    public ThumbnailStorePrx createThumbnailStore(OriginalFile file, Current __current) {
        return null;
    }

    protected OriginalFileI getDescription(final long id) throws ServerError {
        ome.model.core.OriginalFile file = (ome.model.core.OriginalFile)this.ex.execute(this.p, (Executor.Work)new Executor.SimpleWork(this, "getDescription", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery("select o from OriginalFile o where o.id = " + id, null);
            }
        });
        OriginalFileI rv = (OriginalFileI)new IceMapper().map((Filterable)file);
        return rv;
    }

    protected String getFileRepo(final OriginalFile file) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ValidationException(null, null, "Unmanaged file");
        }
        Map map = (Map)this.ex.executeSql((Executor.SqlWork)new Executor.SimpleSqlWork(this, "getFileRepo", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return sql.repoFile(file.getId().getValue());
            }
        });
        if (map.size() == 0) {
            throw new ValidationException(null, null, "Unknown file: " + file.getId().getValue());
        }
        return (String)map.get("repo");
    }

    private abstract class GetOrCreateRepo
    extends Executor.SimpleWork {
        private ServiceFactory sf;
        RepositoryPrx publicPrx;

        private GetOrCreateRepo(Object object, String method) {
            super(object, method, new Object[0]);
        }

        protected Object innerWork(ServiceFactory sf) {
            try {
                this.sf = sf;
                String line = this.handleFileMaker();
                ome.model.core.OriginalFile r = this.handleRepository(line);
                this.handleServants(r);
                return r;
            }
            catch (Exception e) {
                AbstractRepositoryI.this.fileMaker.close();
                return e;
            }
        }

        private String handleFileMaker() throws Exception {
            String line;
            block5: {
                if (AbstractRepositoryI.this.fileMaker.needsInit()) {
                    AbstractRepositoryI.this.fileMaker.init(this.sf.getConfigService().getDatabaseUuid(), AbstractRepositoryI.this.readOnly.isReadOnlyRepo());
                }
                line = null;
                try {
                    line = AbstractRepositoryI.this.fileMaker.getLine();
                }
                catch (OverlappingFileLockException ofle) {
                    InternalRepositoryPrx[] repos = AbstractRepositoryI.this.reg.lookupRepositories();
                    InternalRepositoryPrx prx = null;
                    if (repos != null) {
                        for (int i = 0; i < repos.length; ++i) {
                            if (repos[i] == null || !repos[i].toString().contains(AbstractRepositoryI.this.repoUuid)) continue;
                            prx = repos[i];
                        }
                    }
                    if (prx != null) break block5;
                    AbstractRepositoryI.this.fileMaker.close();
                    FileMaker newFileMaker = new FileMaker(new File(AbstractRepositoryI.this.fileMaker.getDir()).getAbsolutePath());
                    AbstractRepositoryI.this.fileMaker.init(this.sf.getConfigService().getDatabaseUuid(), AbstractRepositoryI.this.readOnly.isReadOnlyRepo());
                    line = newFileMaker.getLine();
                }
            }
            return line;
        }

        private ome.model.core.OriginalFile handleRepository(String line) throws Exception {
            if (line == null) {
                AbstractRepositoryI.this.repoUuid = AbstractRepositoryI.this.generateRepoUuid();
            } else {
                AbstractRepositoryI.this.repoUuid = line;
            }
            ome.model.core.OriginalFile r = (ome.model.core.OriginalFile)this.sf.getQueryService().findByString(ome.model.core.OriginalFile.class, "hash", AbstractRepositoryI.this.repoUuid);
            if (!AbstractRepositoryI.this.readOnly.isReadOnlyDb() && !AbstractRepositoryI.this.readOnly.isReadOnlyRepo()) {
                r = this.handleRepoChanges(r, line);
            }
            if (r == null) {
                throw new NullPointerException("No repository to open!");
            }
            log.info(String.format("Opened repository %s (uuid=%s)", r.getName(), AbstractRepositoryI.this.repoUuid));
            return r;
        }

        private ome.model.core.OriginalFile handleRepoChanges(ome.model.core.OriginalFile r, String line) throws Exception {
            String path = FilenameUtils.normalize((String)new File(AbstractRepositoryI.this.fileMaker.getDir()).getAbsolutePath());
            String pathName = FilenameUtils.getName((String)path);
            String pathDir = FilenameUtils.getFullPath((String)path);
            if (r == null) {
                if (line != null) {
                    log.warn("Couldn't find repository object: " + line);
                }
                r = new ome.model.core.OriginalFile();
                r.setHash(AbstractRepositoryI.this.repoUuid);
                r.setName(pathName);
                r.setPath(pathDir);
                Timestamp t = new Timestamp(System.currentTimeMillis());
                r.setAtime(t);
                r.setMtime(t);
                r.setCtime(t);
                r.setMimetype("Repository");
                r.setSize(Long.valueOf(0L));
                r = (ome.model.core.OriginalFile)this.sf.getUpdateService().saveAndReturnObject((IObject)r);
                AbstractRepositoryI.this.fileMaker.writeLine(AbstractRepositoryI.this.repoUuid);
                log.info(String.format("Registered new repository %s (uuid=%s)", r.getName(), AbstractRepositoryI.this.repoUuid));
            } else if (!r.getPath().equals(pathDir) || !r.getName().equals(pathName)) {
                String oldPath = r.getPath();
                String oldName = r.getName();
                r.setPath(pathDir);
                r.setName(pathName);
                r = (ome.model.core.OriginalFile)this.sf.getUpdateService().saveAndReturnObject((IObject)r);
                log.warn("Data directory moved: {}{} updated to {}{}", new Object[]{oldPath, oldName, pathDir, pathName});
            }
            this.sf.getAdminService().moveToCommonSpace(new IObject[]{r});
            return r;
        }

        private void handleServants(ome.model.core.OriginalFile r) throws Exception {
            AbstractRepositoryI.this.servant.initialize(AbstractRepositoryI.this.fileMaker, r.getId(), AbstractRepositoryI.this.repoUuid);
            LinkedList<ObjectPrx> objs = new LinkedList<ObjectPrx>();
            objs.add(this.addOrReplace("InternalRepository-", AbstractRepositoryI.this));
            objs.add(this.addOrReplace("PublicRepository-", AbstractRepositoryI.this.servant.tie()));
            this.publicPrx = RepositoryPrxHelper.uncheckedCast((ObjectPrx)objs.getLast());
            AbstractRepositoryI.this.oa.activate();
            for (ObjectPrx prx : objs) {
                AbstractRepositoryI.this.reg.addObject(prx);
            }
            log.info("Repository now active");
        }

        private ObjectPrx addOrReplace(String prefix, Ice.Object obj) {
            Identity id = Util.stringToIdentity((String)(prefix + AbstractRepositoryI.this.repoUuid));
            Ice.Object old = AbstractRepositoryI.this.oa.find(id);
            if (old != null) {
                AbstractRepositoryI.this.oa.remove(id);
                log.warn(String.format("Found %s; removing: %s", id, old));
            }
            AbstractRepositoryI.this.oa.add(obj, id);
            return AbstractRepositoryI.this.oa.createDirectProxy(id);
        }
    }

    private static enum State {
        ACTIVE,
        EAGER,
        WAITING,
        CLOSED;

    }
}

