/*
 * Decompiled with CFR 0.152.
 */
package ome.services.roi;

import java.io.IOException;
import ome.api.IPixels;
import ome.conditions.ApiUsageException;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.model.core.Pixels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelData {
    protected Logger log = LoggerFactory.getLogger(PixelData.class);
    protected final PixelsService data;
    protected final IPixels meta;

    public PixelData(PixelsService data, IPixels meta) {
        this.data = data;
        this.meta = meta;
    }

    public PixelBuffer getBuffer(long pix) {
        return this.data.getPixelBuffer(this.meta.retrievePixDescription(pix), false);
    }

    public double get(PixelBuffer buf, int x, int y, int z, int c, int t) {
        ome.util.PixelData pd = null;
        try {
            pd = buf.getRow(Integer.valueOf(y), Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t));
            double d = pd.getPixelValue(x);
            return d;
        }
        catch (IOException e) {
            throw new ResourceError("IOException: " + e);
        }
        catch (DimensionsOutOfBoundsException e) {
            throw new ApiUsageException("DimensionsOutOfBounds: " + (Object)((Object)e));
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new ValidationException("IndexOutOfBounds: " + iobe);
        }
        finally {
            if (pd != null) {
                pd.dispose();
            }
        }
    }

    public ome.util.PixelData getPlane(PixelBuffer buf, int z, int c, int t) {
        try {
            return buf.getPlane(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t));
        }
        catch (IOException e) {
            throw new ResourceError("IOException: " + e);
        }
        catch (DimensionsOutOfBoundsException e) {
            throw new ApiUsageException("DimensionsOutOfBounds: " + (Object)((Object)e));
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new ValidationException("IndexOutOfBounds: " + iobe);
        }
    }

    public boolean requiresPixelsPyramid(Pixels pix) {
        return this.data.requiresPixelsPyramid(pix);
    }
}

