/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Folder;
import omero.model.FolderRoiLink;
import omero.model.FolderRoiLinkI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.OriginalFile;
import omero.model.Roi;
import omero.model.RoiAnnotationLink;
import omero.model.RoiAnnotationLinkI;
import omero.model.Shape;
import omero.rtypes;
import omero.util.IceMapper;

public class RoiI
extends Roi
implements ModelBased {
    public static final String NAME = "ome.model.roi.Roi_name";
    public static final String SHAPES = "ome.model.roi.Roi_shapes";
    public static final String IMAGE = "ome.model.roi.Roi_image";
    public static final String SOURCE = "ome.model.roi.Roi_source";
    public static final String FOLDERLINKS = "ome.model.roi.Roi_folderLinks";
    public static final String ANNOTATIONLINKS = "ome.model.roi.Roi_annotationLinks";
    public static final String DESCRIPTION = "ome.model.roi.Roi_description";
    public static final String DETAILS = "ome.model.roi.Roi_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.shapesSeq = new ArrayList();
            this.shapesLoaded = true;
        } else {
            this.shapesSeq = null;
            this.shapesLoaded = false;
        }
        if (load) {
            this.folderLinksSeq = new ArrayList();
            this.folderLinksLoaded = true;
        } else {
            this.folderLinksSeq = null;
            this.folderLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public RoiI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public RoiI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public RoiI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadName();
        this.unloadShapes();
        this.unloadImage();
        this.unloadSource();
        this.unloadFolderLinks();
        this.unloadAnnotationLinks();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        RoiI copy = new RoiI();
        copy.id = this.id;
        copy.version = this.version;
        copy.name = this.name;
        if (!this.shapesLoaded) {
            copy.shapesLoaded = false;
            copy.shapesSeq = null;
        } else {
            copy.shapesLoaded = true;
            copy.shapesSeq = new ArrayList<Shape>();
            for (IObject item : this.shapesSeq) {
                copy.shapesSeq.add(item == null ? null : (Shape)item.proxy());
            }
        }
        copy.image = this.image == null ? null : (Image)this.image.proxy();
        OriginalFile originalFile = copy.source = this.source == null ? null : (OriginalFile)this.source.proxy();
        if (!this.folderLinksLoaded) {
            copy.folderLinksLoaded = false;
            copy.folderLinksSeq = null;
        } else {
            copy.folderLinksLoaded = true;
            copy.folderLinksSeq = new ArrayList<FolderRoiLink>();
            for (IObject item : this.folderLinksSeq) {
                copy.folderLinksSeq.add(item == null ? null : (FolderRoiLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<RoiAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (RoiAnnotationLink)item.proxy());
            }
        }
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new RoiI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.roi.Roi source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.roi.Roi target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadShapes(Current current) {
        this.shapesLoaded = false;
        this.shapesSeq = null;
    }

    protected List getShapes(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.shapesSeq;
    }

    protected void setShapes(List shapes, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.shapesSeq = shapes == null ? new ArrayList() : new ArrayList(shapes);
        this.shapesLoaded = shapes != null;
    }

    private void copyShapes(ome.model.roi.Roi source, IceMapper mapper) {
        this.setShapes((List)mapper.findCollection((Collection)source.retrieve(SHAPES)), null);
    }

    private void fillShapes(ome.model.roi.Roi target, IceMapper mapper) {
        if (this.shapesLoaded) {
            target.putAt(SHAPES, (Object)mapper.reverse(this.shapesSeq, List.class));
        } else {
            target.putAt(SHAPES, null);
        }
    }

    public boolean isShapesLoaded() {
        return this.shapesLoaded;
    }

    @Override
    public int sizeOfShapes(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            return -1;
        }
        return this.shapesSeq.size();
    }

    public List copyShapes(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        ArrayList result = new ArrayList(this.shapesSeq);
        return result;
    }

    public Iterator iterateShapes() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        return this.shapesSeq.iterator();
    }

    @Override
    public void addShape(Shape target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        this.shapesSeq.add(target);
        target.setRoi(this);
    }

    @Override
    public void addAllShapeSet(List<Shape> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        this.shapesSeq.addAll(targets);
        for (Shape target : targets) {
            target.setRoi(this);
        }
    }

    @Override
    public void removeShape(Shape target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        this.shapesSeq.remove(target);
        target.setRoi(null);
    }

    @Override
    public void removeAllShapeSet(List<Shape> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        for (Shape elt : targets) {
            elt.setRoi(null);
            this.shapesSeq.remove(elt);
        }
    }

    @Override
    public void clearShapes(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        for (Shape elt : this.shapesSeq) {
            elt.setRoi(null);
        }
        this.shapesSeq.clear();
    }

    @Override
    public void reloadShapes(Roi toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.shapesLoaded) {
            throw new ClientError("Cannot reload active collection: shapesSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Shape> copy = toCopy.copyShapes();
        for (Shape elt : copy) {
            elt.setRoi(this);
        }
        this.shapesSeq = new ArrayList<Shape>(copy);
        toCopy.unloadShapes();
        this.shapesLoaded = true;
    }

    @Override
    public Shape getShape(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        return (Shape)this.shapesSeq.get(index);
    }

    @Override
    public Shape setShape(int index, Shape element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        Shape old = this.shapesSeq.set(index, element);
        if (element != null && element.isLoaded()) {
            element.setRoi(this);
        }
        return old;
    }

    @Override
    public Shape getPrimaryShape(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        return (Shape)this.shapesSeq.get(0);
    }

    @Override
    public Shape setPrimaryShape(Shape element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.shapesLoaded) {
            this.throwNullCollectionException("shapesSeq");
        }
        int index = this.shapesSeq.indexOf(element);
        Shape old = (Shape)this.shapesSeq.get(0);
        this.shapesSeq.set(index, old);
        this.shapesSeq.set(0, element);
        return old;
    }

    public void unloadImage() {
        this.image = null;
    }

    @Override
    public Image getImage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.image;
    }

    @Override
    public void setImage(Image image, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.image = image;
    }

    private void copyImage(ome.model.roi.Roi source, IceMapper mapper) {
        this.image = (Image)mapper.findTarget(source.getImage());
    }

    private void fillImage(ome.model.roi.Roi target, IceMapper mapper) {
        target.putAt(IMAGE, (Object)mapper.reverse((ModelBased)this.getImage()));
    }

    public void unloadSource() {
        this.source = null;
    }

    @Override
    public OriginalFile getSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.source;
    }

    @Override
    public void setSource(OriginalFile source, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.source = source;
    }

    private void copySource(ome.model.roi.Roi source, IceMapper mapper) {
        this.source = (OriginalFile)mapper.findTarget(source.getSource());
    }

    private void fillSource(ome.model.roi.Roi target, IceMapper mapper) {
        target.putAt(SOURCE, (Object)mapper.reverse((ModelBased)this.getSource()));
    }

    @Override
    public void unloadFolderLinks(Current current) {
        this.folderLinksLoaded = false;
        this.folderLinksSeq = null;
    }

    protected List getFolderLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.folderLinksSeq;
    }

    protected void setFolderLinks(List folderLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.folderLinksSeq = folderLinks == null ? new ArrayList() : new ArrayList(folderLinks);
        this.folderLinksLoaded = folderLinks != null;
    }

    private void copyFolderLinks(ome.model.roi.Roi source, IceMapper mapper) {
        this.setFolderLinks((List)mapper.findCollection((Collection)source.retrieve(FOLDERLINKS)), null);
        this.folderLinksCountPerOwner = source.getFolderLinksCountPerOwner();
    }

    private void fillFolderLinks(ome.model.roi.Roi target, IceMapper mapper) {
        if (this.folderLinksLoaded) {
            target.putAt(FOLDERLINKS, (Object)mapper.reverse(this.folderLinksSeq, Set.class));
        } else {
            target.putAt(FOLDERLINKS, null);
        }
    }

    public boolean isFolderLinksLoaded() {
        return this.folderLinksLoaded;
    }

    @Override
    public int sizeOfFolderLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            return -1;
        }
        return this.folderLinksSeq.size();
    }

    public List copyFolderLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        ArrayList result = new ArrayList(this.folderLinksSeq);
        return result;
    }

    public Iterator iterateFolderLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        return this.folderLinksSeq.iterator();
    }

    @Override
    public void addFolderRoiLink(FolderRoiLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        this.folderLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllFolderRoiLinkSet(List<FolderRoiLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        this.folderLinksSeq.addAll(targets);
        for (FolderRoiLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeFolderRoiLink(FolderRoiLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        this.folderLinksSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllFolderRoiLinkSet(List<FolderRoiLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        for (FolderRoiLink elt : targets) {
            elt.setChild(null);
            this.folderLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearFolderLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        for (FolderRoiLink elt : this.folderLinksSeq) {
            elt.setChild(null);
        }
        this.folderLinksSeq.clear();
    }

    @Override
    public void reloadFolderLinks(Roi toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.folderLinksLoaded) {
            throw new ClientError("Cannot reload active collection: folderLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FolderRoiLink> copy = toCopy.copyFolderLinks();
        for (FolderRoiLink elt : copy) {
            elt.setChild(this);
        }
        this.folderLinksSeq = new ArrayList<FolderRoiLink>(copy);
        toCopy.unloadFolderLinks();
        this.folderLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getFolderLinksCountPerOwner(Current current) {
        return this.folderLinksCountPerOwner;
    }

    @Override
    public FolderRoiLink linkFolder(Folder addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        FolderRoiLinkI link = new FolderRoiLinkI();
        link.link(addition, this);
        this.addFolderRoiLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFolderRoiLinkToBoth(FolderRoiLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        this.folderLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addFolderRoiLinkToBoth(link, false);
        }
    }

    @Override
    public List<FolderRoiLink> findFolderRoiLink(Folder removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        ArrayList<FolderRoiLink> result = new ArrayList<FolderRoiLink>();
        for (FolderRoiLink link : this.folderLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkFolder(Folder removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        List<FolderRoiLink> toRemove = this.findFolderRoiLink(removal);
        Iterator<FolderRoiLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderRoiLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFolderRoiLinkFromBoth(FolderRoiLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("folderLinksSeq");
        }
        this.folderLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeFolderRoiLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Folder> linkedFolderList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.folderLinksLoaded) {
            this.throwNullCollectionException("FolderLinks");
        }
        ArrayList<Folder> linked = new ArrayList<Folder>();
        for (FolderRoiLink link : this.folderLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.roi.Roi source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.roi.Roi target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addRoiAnnotationLink(RoiAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllRoiAnnotationLinkSet(List<RoiAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (RoiAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeRoiAnnotationLink(RoiAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllRoiAnnotationLinkSet(List<RoiAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (RoiAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (RoiAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Roi toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<RoiAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (RoiAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<RoiAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public RoiAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        RoiAnnotationLinkI link = new RoiAnnotationLinkI();
        link.link(this, addition);
        this.addRoiAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addRoiAnnotationLinkToBoth(RoiAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<RoiAnnotationLink> findRoiAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<RoiAnnotationLink> result = new ArrayList<RoiAnnotationLink>();
        for (RoiAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<RoiAnnotationLink> toRemove = this.findRoiAnnotationLink(removal);
        Iterator<RoiAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeRoiAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeRoiAnnotationLinkFromBoth(RoiAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (RoiAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.roi.Roi source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.roi.Roi target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.roi.Roi) {
            ome.model.roi.Roi source = (ome.model.roi.Roi)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyName(source, mapper);
                this.copyShapes(source, mapper);
                this.copyImage(source, mapper);
                this.copySource(source, mapper);
                this.copyFolderLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Roi cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.roi.Roi target = new ome.model.roi.Roi();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillName(target, mapper);
            this.fillShapes(target, mapper);
            this.fillImage(target, mapper);
            this.fillSource(target, mapper);
            this.fillFolderLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<RoiI> cast(List list) {
        return list;
    }
}

