/*
 * Decompiled with CFR 0.152.
 */
package ome.system.utests;

import java.util.Properties;
import ome.conditions.ApiUsageException;
import ome.system.Login;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoginTest {
    @Test(expectedExceptions={ApiUsageException.class})
    public void test_null_user() throws Exception {
        new Login(null, "");
    }

    @Test(expectedExceptions={ApiUsageException.class})
    public void test_null_password() throws Exception {
        new Login("", null);
    }

    @Test(expectedExceptions={ApiUsageException.class})
    public void test_null_user_ext() throws Exception {
        new Login(null, "", null, null);
    }

    @Test(expectedExceptions={ApiUsageException.class})
    public void test_null_password_ext() throws Exception {
        new Login("", null, null, null);
    }

    @Test
    public void test_asProperties() throws Exception {
        Login l = new Login("a", "b");
        Properties p = l.asProperties();
        Assert.assertNotNull((Object)p.getProperty("omero.user"));
        Assert.assertNotNull((Object)p.getProperty("omero.pass"));
        Assert.assertNull((Object)p.getProperty("omero.group"));
        Assert.assertNull((Object)p.getProperty("omero.event"));
        Assert.assertEquals((String)p.getProperty("omero.user"), (String)"a");
        Assert.assertEquals((String)p.getProperty("omero.pass"), (String)"b");
    }

    @Test
    public void test_asProperties_extNulls() throws Exception {
        Login l = new Login("a", "b", null, null);
        Properties p = l.asProperties();
        Assert.assertNotNull((Object)p.getProperty("omero.user"));
        Assert.assertNotNull((Object)p.getProperty("omero.pass"));
        Assert.assertNull((Object)p.getProperty("omero.group"));
        Assert.assertNull((Object)p.getProperty("omero.event"));
        Assert.assertEquals((String)p.getProperty("omero.user"), (String)"a");
        Assert.assertEquals((String)p.getProperty("omero.pass"), (String)"b");
    }

    @Test
    public void test_asProperties_ext() throws Exception {
        Login l = new Login("a", "b", "c", "d");
        Properties p = l.asProperties();
        Assert.assertNotNull((Object)p.getProperty("omero.user"));
        Assert.assertNotNull((Object)p.getProperty("omero.pass"));
        Assert.assertNotNull((Object)p.getProperty("omero.group"));
        Assert.assertNotNull((Object)p.getProperty("omero.event"));
        Assert.assertEquals((String)p.getProperty("omero.user"), (String)"a");
        Assert.assertEquals((String)p.getProperty("omero.pass"), (String)"b");
        Assert.assertEquals((String)p.getProperty("omero.group"), (String)"c");
        Assert.assertEquals((String)p.getProperty("omero.event"), (String)"d");
    }

    @Test
    public void test_getters() throws Exception {
        Login l = new Login("a", "b");
        Assert.assertNotNull((Object)l.getName());
        Assert.assertEquals((String)l.getName(), (String)"a");
        Assert.assertNotNull((Object)l.getPassword());
        Assert.assertEquals((String)l.getPassword(), (String)"b");
        Assert.assertNull((Object)l.getGroup());
        Assert.assertNull((Object)l.getEvent());
    }

    @Test
    public void test_getters_extNulls() throws Exception {
        Login l = new Login("a", "b", null, null);
        Assert.assertNotNull((Object)l.getName());
        Assert.assertEquals((String)l.getName(), (String)"a");
        Assert.assertNotNull((Object)l.getPassword());
        Assert.assertEquals((String)l.getPassword(), (String)"b");
        Assert.assertNull((Object)l.getGroup());
        Assert.assertNull((Object)l.getEvent());
    }

    @Test
    public void test_getters_ext() throws Exception {
        Login l = new Login("a", "b", "c", "d");
        Assert.assertNotNull((Object)l.getName());
        Assert.assertEquals((String)l.getName(), (String)"a");
        Assert.assertNotNull((Object)l.getPassword());
        Assert.assertEquals((String)l.getPassword(), (String)"b");
        Assert.assertNotNull((Object)l.getGroup());
        Assert.assertEquals((String)l.getGroup(), (String)"c");
        Assert.assertNotNull((Object)l.getEvent());
        Assert.assertEquals((String)l.getEvent(), (String)"d");
    }
}

