/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RInt;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.ObjectiveData;
import omero.model.IObject;
import omero.model.OTF;

public class OTFData
extends DataObject {
    private ObjectiveData objective;
    private FilterSetData filterSet;

    public OTFData(OTF otf) {
        if (otf == null) {
            throw new IllegalArgumentException("OTF cannot null.");
        }
        this.setValue((IObject)otf);
    }

    public ObjectiveData getObjective() {
        if (this.objective != null) {
            return this.objective;
        }
        this.objective = new ObjectiveData(((OTF)this.asIObject()).getObjective());
        return this.objective;
    }

    public FilterSetData getFilterSet() {
        if (this.filterSet != null) {
            return this.filterSet;
        }
        this.filterSet = new FilterSetData(((OTF)this.asIObject()).getFilterSet());
        return this.filterSet;
    }

    public boolean hasOpticalAxisAveraged() {
        OTF otf = (OTF)this.asIObject();
        return otf.getOpticalAxisAveraged().getValue();
    }

    public String getPath() {
        OTF otf = (OTF)this.asIObject();
        return otf.getPath().getValue();
    }

    public int getSizeX() {
        OTF otf = (OTF)this.asIObject();
        RInt v = otf.getSizeX();
        return v.getValue();
    }

    public int getSizeY() {
        OTF otf = (OTF)this.asIObject();
        RInt v = otf.getSizeY();
        return v.getValue();
    }

    public String getPixelsType() {
        OTF otf = (OTF)this.asIObject();
        return otf.getPixelsType().getValue().getValue();
    }
}

