/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.util.HashMap;
import java.util.Map;
import omero.gateway.exception.DSAccessException;
import omero.gateway.model.TableResult;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.DoubleColumn;
import omero.grid.ImageColumn;
import omero.grid.LongColumn;
import omero.grid.RoiColumn;
import omero.grid.StringColumn;
import omero.grid.TablePrx;
import omero.grid.WellColumn;

public class PyTablesUtils {
    private static final int MAX_TABLE_ROW_RETRIEVAL = 100000;

    public static TableResult createTableResult(TablePrx table, String key, long id) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            key = "(" + (String)key + "==%d)";
            long totalRowCount = table.getNumberOfRows();
            long[] rows = table.getWhereList(String.format((String)key, id), null, 0L, totalRowCount, 1L);
            return PyTablesUtils.createTableResult(table, rows);
        }
        catch (Exception e) {
            throw new DSAccessException("Unable to read the table.", e);
        }
    }

    public static TableResult createTableResult(TablePrx table, long[] rows) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            Column[] cols = table.getHeaders();
            String[] headers = new String[cols.length];
            String[] headersDescriptions = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                headers[i] = cols[i].name;
                headersDescriptions[i] = cols[i].description;
            }
            int totalRowCount = rows.length;
            Object[][] data = new Object[totalRowCount][cols.length];
            long[] columns = new long[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                columns[i] = i;
            }
            int rowOffset = 0;
            int rowCount = 0;
            HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
            for (int rowsToGo = totalRowCount; rowsToGo > 0; rowsToGo -= rowCount) {
                rowCount = Math.min(100000, totalRowCount - rowOffset);
                long[] rowSubset = new long[rowCount];
                System.arraycopy(rows, rowOffset, rowSubset, 0, rowCount);
                Data d = table.slice(columns, rowSubset);
                for (int i = 0; i < cols.length; ++i) {
                    PyTablesUtils.translateTableResult(d, data, rowOffset, rowCount, indexes);
                }
                rowOffset += rowCount;
            }
            TableResult tr = new TableResult(data, headers);
            tr.setIndexes(indexes);
            TableResult tableResult = tr;
            return tableResult;
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DSAccessException("Unable to read the table.", e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void translateTableResult(Data src, Object[][] dst, int offset, int length, Map<Integer, Integer> indexes) {
        Column[] cols = src.columns;
        for (int i = 0; i < cols.length; ++i) {
            int j;
            Column column = cols[i];
            if (column instanceof LongColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((LongColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof DoubleColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((DoubleColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof StringColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((StringColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof BoolColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((BoolColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof RoiColumn) {
                indexes.put(TableResult.ROI_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((RoiColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof ImageColumn) {
                indexes.put(TableResult.IMAGE_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((ImageColumn)column).values[j];
                }
                continue;
            }
            if (!(column instanceof WellColumn)) continue;
            indexes.put(TableResult.WELL_COLUMN_INDEX, i);
            for (j = 0; j < length; ++j) {
                dst[j + offset][i] = ((WellColumn)column).values[j];
            }
        }
    }
}

