/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.model.MaskData;
import omero.gateway.model.ROIData;
import omero.model.Image;
import omero.model.ImageI;

public class ROIComponent {
    private Map<Integer, ROIData> roiColour;
    private long imageId;

    public ROIComponent(long imageId) {
        this.imageId = imageId;
        this.roiColour = new HashMap<Integer, ROIData>();
    }

    public void addMasks(Map<Integer, MaskData> maskSet) {
        for (int colour : maskSet.keySet()) {
            ROIData roi;
            if (!this.roiColour.containsKey(colour)) {
                roi = new ROIData();
                roi.setImage((Image)new ImageI(this.imageId, false));
                this.roiColour.put(colour, roi);
            } else {
                roi = this.roiColour.get(colour);
            }
            roi.addShapeData(maskSet.get(colour));
        }
    }

    public List<ROIData> getROI() {
        ArrayList<ROIData> roiList = new ArrayList<ROIData>();
        Iterator<Integer> colourIterator = this.roiColour.keySet().iterator();
        while (colourIterator.hasNext()) {
            roiList.add(this.roiColour.get(colourIterator.next()));
        }
        return roiList;
    }
}

