/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    static List<String> MECHANISMS = new ArrayList<String>(1);
    private UsernamePasswordValidator helper;

    public PlainAuthenticationHandlerFactory(UsernamePasswordValidator helper) {
        this.helper = helper;
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return MECHANISMS;
    }

    @Override
    public AuthenticationHandler create() {
        return new Handler();
    }

    static {
        MECHANISMS.add("PLAIN");
    }

    class Handler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Handler() {
        }

        public String auth(String clientInput) throws RejectException {
            int j;
            int i;
            byte[] decodedSecret;
            StringTokenizer stk = new StringTokenizer(clientInput);
            String secret = stk.nextToken();
            if (secret.trim().equalsIgnoreCase("AUTH")) {
                if (!stk.nextToken().trim().equalsIgnoreCase("PLAIN")) {
                    throw new RejectException(504, "AUTH mechanism mismatch");
                }
                if (stk.hasMoreTokens()) {
                    secret = stk.nextToken();
                } else {
                    return "334 Ok";
                }
            }
            if ((decodedSecret = Base64.decode(secret)) == null) {
                throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
            }
            for (i = 0; i < decodedSecret.length && decodedSecret[i] != 0; ++i) {
            }
            if (i >= decodedSecret.length) {
                throw new RejectException(501, "Invalid command argument, does not contain NUL");
            }
            for (j = i + 1; j < decodedSecret.length && decodedSecret[j] != 0; ++j) {
            }
            if (j >= decodedSecret.length) {
                throw new RejectException(501, "Invalid command argument, does not contain the second NUL");
            }
            String authorizationId = new String(decodedSecret, 0, i);
            String authenticationId = new String(decodedSecret, i + 1, j - i - 1);
            String passwd = new String(decodedSecret, j + 1, decodedSecret.length - j - 1);
            this.username = authenticationId;
            this.password = passwd;
            try {
                PlainAuthenticationHandlerFactory.this.helper.login(this.username.toString(), this.password);
            }
            catch (LoginFailedException lfe) {
                throw new RejectException(535, "Authentication credentials invalid");
            }
            return null;
        }

        public Object getIdentity() {
            return this.username;
        }
    }
}

