/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.SMTPClient;
import org.subethamail.smtp.client.SMTPException;

public class SmartClient
extends SMTPClient {
    private static Logger log = LoggerFactory.getLogger(SmartClient.class);
    boolean sentFrom;
    int recipientCount;
    private String heloHost;
    private boolean serverClosingTransmissionChannel = false;

    public SmartClient() {
    }

    public SmartClient(String host, int port, String myHost) throws UnknownHostException, IOException, SMTPException {
        this(host, port, null, myHost);
    }

    public SmartClient(String host, int port, SocketAddress bindpoint, String myHost) throws UnknownHostException, IOException, SMTPException {
        this.setBindpoint(bindpoint);
        this.setHeloHost(myHost);
        this.connect(host, port);
    }

    public void connect(String host, int port) throws IOException, SMTPException {
        if (this.heloHost == null) {
            throw new IllegalStateException("Helo host must be specified before connecting");
        }
        super.connect(host, port);
        try {
            this.receiveAndCheck();
            this.sendAndCheck("HELO " + this.heloHost);
        }
        catch (SMTPException e) {
            this.quit();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected SMTPClient.Response receive() throws IOException {
        SMTPClient.Response response = super.receive();
        if (response.getCode() == 421) {
            this.serverClosingTransmissionChannel = true;
        }
        return response;
    }

    public void from(String from) throws IOException, SMTPException {
        this.sendAndCheck("MAIL FROM: <" + from + ">");
        this.sentFrom = true;
    }

    public void to(String to) throws IOException, SMTPException {
        this.sendAndCheck("RCPT TO: <" + to + ">");
        ++this.recipientCount;
    }

    public void dataStart() throws IOException, SMTPException {
        this.sendAndCheck("DATA");
    }

    public void dataWrite(byte[] data, int numBytes) throws IOException {
        this.dataOutput.write(data, 0, numBytes);
    }

    public void dataEnd() throws IOException, SMTPException {
        this.dataOutput.flush();
        this.dotTerminatedOutput.writeTerminatingSequence();
        this.dotTerminatedOutput.flush();
        this.receiveAndCheck();
    }

    public void quit() {
        try {
            if (!this.serverClosingTransmissionChannel) {
                this.sendAndCheck("QUIT");
            }
        }
        catch (IOException ex) {
            log.warn("Failed to issue QUIT to " + this.hostPort);
        }
        this.close();
    }

    public boolean sentFrom() {
        return this.sentFrom;
    }

    public boolean sentTo() {
        return this.recipientCount > 0;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public void setHeloHost(String myHost) {
        this.heloHost = myHost;
    }

    public String getHeloHost() {
        return this.heloHost;
    }
}

