/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JavaProxyBase<T>
implements InvocationHandler {
    private static final Map<Method, String> methodKeyMap = new ConcurrentHashMap<Method, String>();
    protected Object proxy;
    protected T delegate;

    protected abstract Map<String, Method> getMethodMap();

    protected T getProxy() {
        return (T)this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Proxy.isProxyClass(proxy.getClass())) {
            this.proxy = proxy;
        }
        try {
            Method ourMethod = this.getMethodMap().get(JavaProxyBase.getMethodKey(method));
            if (ourMethod != null) {
                return ourMethod.invoke((Object)this, args);
            }
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected static Map<String, Method> createMethodMap(Class<?> clazz) {
        HashMap<String, Method> selfMethodMap = new HashMap<String, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if ((method.getModifiers() & 0) != 0) continue;
            selfMethodMap.put(JavaProxyBase.getMethodKey(method), method);
        }
        return selfMethodMap;
    }

    protected static String getMethodKey(Method method) {
        String key = methodKeyMap.get(method);
        if (key != null) {
            return key;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append(method.getName());
        for (Class<?> type : method.getParameterTypes()) {
            sb.append(type.getName());
        }
        key = sb.toString();
        methodKeyMap.put(method, key);
        return key;
    }

    protected static boolean isWrapperFor(Object obj, Class<?> param) {
        try {
            Method isWrapperForMethod = obj.getClass().getMethod("isWrapperFor", Class.class);
            return (Boolean)isWrapperForMethod.invoke(obj, param);
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException("isWrapperFor is not supported", ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("isWrapperFor is not supported", ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedOperationException("isWrapperFor is not supported", ex);
        }
    }

    protected static <T> T unwrap(Object obj, Class<T> param) {
        try {
            Method unwrapMethod = obj.getClass().getMethod("unwrap", Class.class);
            return (T)unwrapMethod.invoke(obj, param);
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException("unwrap is not supported", ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("unwrap is not supported", ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedOperationException("unwrap is not supported", ex);
        }
    }
}

