/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.XAStatefulHolder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXAStatefulHolder<T extends XAStatefulHolder<T>>
implements XAStatefulHolder<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractXAStatefulHolder.class);
    private volatile XAStatefulHolder.State state = XAStatefulHolder.State.IN_POOL;
    private final List<StateChangeListener<T>> stateChangeEventListeners = new CopyOnWriteArrayList<StateChangeListener<T>>();
    private final Date creationDate = new Date();

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public XAStatefulHolder.State getState() {
        return this.state;
    }

    @Override
    public void setState(XAStatefulHolder.State state) {
        XAStatefulHolder.State oldState = this.state;
        this.fireStateChanging(oldState, state);
        if (oldState == state) {
            throw new IllegalArgumentException("cannot switch state from " + (Object)((Object)oldState) + " to " + (Object)((Object)state));
        }
        if (log.isDebugEnabled()) {
            log.debug("state changing from " + (Object)((Object)oldState) + " to " + (Object)((Object)state) + " in " + this);
        }
        this.state = state;
        this.fireStateChanged(oldState, state);
    }

    @Override
    public void addStateChangeEventListener(StateChangeListener<T> listener) {
        this.stateChangeEventListeners.add(listener);
    }

    @Override
    public void removeStateChangeEventListener(StateChangeListener<T> listener) {
        this.stateChangeEventListeners.remove(listener);
    }

    private void fireStateChanging(XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changing from " + (Object)((Object)currentState) + " to " + (Object)((Object)futureState) + " in " + this);
        }
        for (StateChangeListener<AbstractXAStatefulHolder> stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanging(this, currentState, futureState);
        }
    }

    private void fireStateChanged(XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState) + " in " + this);
        }
        for (StateChangeListener<AbstractXAStatefulHolder> stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanged(this, oldState, newState);
        }
    }
}

