/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellData;
import omero.model.IObject;
import omero.sys.Parameters;
import omero.sys.ParametersI;

public class LoadFacility
extends Facility {
    private static String GET_DATASETS_QUERY = "select ds from Dataset as ds left join fetch ds.imageLinks as l left join fetch l.child as i where ds.id in (:ids)";
    private static String GET_DATASETS_FOR_PROJECT_QUERY = "select l.child from ProjectDatasetLink l where l.parent.id in (:ids)";
    private static String GET_PROJECTS_QUERY = "select p from Project as p left join fetch p.datasetLinks as l left join fetch l.child as i where p.id in (:ids)";
    private static String GET_IMAGES_QUERY = "select i from Image as i left join fetch i.pixels as p left join fetch p.pixelsType as pt where i.id in (:ids)";
    private static String GET_IMAGES_FOR_DATASET_QUERY = "select l.child from DatasetImageLink l where l.parent.id in (:ids)";
    private static String GET_PLATES_QUERY = "select p from Plate as p left join fetch p.wells as w left join fetch p.plateAcquisitions as pa where p.id in (:ids)";
    private static String GET_PLATES_FOR_SCREEN_QUERY = "select l.child from ScreenPlateLink l where l.parent.id in (:ids)";
    private static String GET_SCREENS_QUERY = "select s from Screen as s left join fetch s.plateLinks as l left join fetch l.child as p where s.id in (:ids)";
    private static String GET_WELLS_QUERY = "select w from Well as w left join fetch w.wellSamples as ws left join fetch w.plate as p left join fetch ws.plateAcquisition as pa left join fetch ws.image as img left join fetch img.pixels as pix left join fetch pix.pixelsType as pt where w.id in (:ids)";
    private static String GET_WELLS_FOR_PLATE_QUERY = "select w from Well as w left join fetch w.wellSamples as ws left join fetch w.plate as p left join fetch ws.plateAcquisition as pa left join fetch ws.image as img left join fetch img.pixels as pix left join fetch pix.pixelsType as pt where p.id in (:ids)";

    LoadFacility(Gateway gateway) {
        super(gateway);
    }

    private <T extends DataObject> Collection<T> queryDb(SecurityContext ctx, String query, Class<T> type, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.addIds(ids);
            List tmp = qs.findAllByQuery(query, (Parameters)param);
            ArrayList<DataObject> result = new ArrayList<DataObject>();
            if (tmp != null && !tmp.isEmpty()) {
                for (IObject o : tmp) {
                    DataObject inst = (DataObject)type.getDeclaredConstructor(o.getClass().getSuperclass()).newInstance(o);
                    result.add(inst);
                }
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ServerError | DSOutOfServiceException e) {
            this.handleException(this, e, "Could not get objects");
            return null;
        }
    }

    public DatasetData getDataset(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<DatasetData> tmp = this.getDatasets(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_DATASETS_QUERY, DatasetData.class, ids);
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx, long projectId) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_DATASETS_FOR_PROJECT_QUERY, DatasetData.class, Collections.singletonList(projectId));
    }

    public ProjectData getProject(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<ProjectData> tmp = this.getProjects(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<ProjectData> getProjects(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_PROJECTS_QUERY, ProjectData.class, ids);
    }

    public ImageData getImage(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<ImageData> tmp = this.getImages(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<ImageData> getImages(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_IMAGES_QUERY, ImageData.class, ids);
    }

    public Collection<ImageData> getImages(SecurityContext ctx, long datasetId) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_IMAGES_FOR_DATASET_QUERY, ImageData.class, Collections.singletonList(datasetId));
    }

    public ScreenData getScreen(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<ScreenData> tmp = this.getScreens(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<ScreenData> getScreens(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_SCREENS_QUERY, ScreenData.class, ids);
    }

    public PlateData getPlate(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<PlateData> tmp = this.getPlates(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<PlateData> getPlates(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_PLATES_QUERY, PlateData.class, ids);
    }

    public Collection<PlateData> getPlates(SecurityContext ctx, long screenId) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_PLATES_FOR_SCREEN_QUERY, PlateData.class, Collections.singletonList(screenId));
    }

    public WellData getWell(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        Collection<WellData> tmp = this.getWells(ctx, Collections.singletonList(id));
        if (tmp.isEmpty()) {
            return null;
        }
        return tmp.iterator().next();
    }

    public Collection<WellData> getWells(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_WELLS_QUERY, WellData.class, ids);
    }

    public Collection<WellData> getWells(SecurityContext ctx, long plateId) throws DSOutOfServiceException, DSAccessException {
        return this.queryDb(ctx, GET_WELLS_FOR_PLATE_QUERY, WellData.class, Collections.singletonList(plateId));
    }
}

