/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.PlateData;
import omero.gateway.model.SetMutator;
import omero.gateway.model.WellSampleData;
import omero.model.IObject;
import omero.model.Well;
import omero.model.WellI;
import omero.model.WellSample;
import omero.rtypes;

public class WellData
extends DataObject {
    private List<WellSampleData> wellSamples;
    private PlateData plate;

    public WellData() {
        this.setDirty(true);
        this.setValue((IObject)new WellI());
    }

    public WellData(Well well) {
        if (well == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        this.setValue((IObject)well);
    }

    public String getExternalDescription() {
        RString d = this.asWell().getExternalDescription();
        return d == null ? null : d.getValue();
    }

    public String getStatus() {
        RString d = this.asWell().getStatus();
        return d == null ? null : d.getValue();
    }

    public String getWellType() {
        RString t = this.asWell().getType();
        return t == null ? null : t.getValue();
    }

    public void setWellType(String type) {
        this.setDirty(true);
        this.asWell().setType(type == null ? null : rtypes.rstring((String)type));
    }

    public int getRed() {
        RInt value = this.asWell().getRed();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setRed(Integer red) {
        this.setDirty(true);
        if (red == null) {
            this.asWell().setRed(null);
            this.asWell().setGreen(null);
            this.asWell().setBlue(null);
            this.asWell().setAlpha(null);
        } else {
            if (red < 0) {
                red = 0;
            }
            if (red > 255) {
                red = 255;
            }
            this.asWell().setRed(rtypes.rint((int)red));
        }
    }

    public int getGreen() {
        RInt value = this.asWell().getGreen();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setGreen(Integer green) {
        this.setDirty(true);
        if (green == null) {
            this.asWell().setRed(null);
            this.asWell().setGreen(null);
            this.asWell().setBlue(null);
            this.asWell().setAlpha(null);
        } else {
            if (green < 0) {
                green = 0;
            }
            if (green > 255) {
                green = 255;
            }
            this.asWell().setGreen(rtypes.rint((int)green));
        }
    }

    public int getBlue() {
        RInt value = this.asWell().getBlue();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setBlue(Integer blue) {
        this.setDirty(true);
        if (blue == null) {
            this.asWell().setRed(null);
            this.asWell().setGreen(null);
            this.asWell().setBlue(null);
            this.asWell().setAlpha(null);
        } else {
            if (blue < 0) {
                blue = 0;
            }
            if (blue > 255) {
                blue = 255;
            }
            this.asWell().setBlue(rtypes.rint((int)blue));
        }
    }

    public int getAlpha() {
        RInt value = this.asWell().getAlpha();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setAlpha(Integer alpha) {
        this.setDirty(true);
        if (alpha == null) {
            this.asWell().setRed(null);
            this.asWell().setGreen(null);
            this.asWell().setBlue(null);
            this.asWell().setAlpha(null);
        } else {
            if (alpha < 0) {
                alpha = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            }
            this.asWell().setAlpha(rtypes.rint((int)alpha));
        }
    }

    public void setExternalDescription(String description) {
        this.setDirty(true);
        this.asWell().setExternalDescription(description == null ? null : rtypes.rstring((String)description));
    }

    public void setStatus(String status) {
        this.setDirty(true);
        this.asWell().setStatus(status == null ? null : rtypes.rstring((String)status));
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asWell().getAnnotationLinksCountPerOwner();
    }

    public Map<Long, Long> getReagentsCounts() {
        return this.asWell().getReagentLinksCountPerOwner();
    }

    public Integer getColumn() {
        RInt c = this.asWell().getColumn();
        return c == null ? null : Integer.valueOf(c.getValue());
    }

    public Integer getRow() {
        RInt r = this.asWell().getRow();
        return r == null ? null : Integer.valueOf(r.getValue());
    }

    public PlateData getPlate() {
        if (this.plate == null) {
            this.plate = new PlateData(this.asWell().getPlate());
        }
        return this.plate;
    }

    public List<WellSampleData> getWellSamples() {
        if (this.wellSamples == null && this.asWell().sizeOfWellSamples() >= 0) {
            this.wellSamples = new ArrayList<WellSampleData>();
            List samples = this.asWell().copyWellSamples();
            for (WellSample sample : samples) {
                if (sample == null) continue;
                this.wellSamples.add(new WellSampleData(sample));
            }
        }
        return this.wellSamples == null ? null : new ArrayList<WellSampleData>(this.wellSamples);
    }

    public void setWellSamples(List<WellSampleData> value) {
        List<WellSampleData> currentValue = this.getWellSamples();
        SetMutator<WellSampleData> m = new SetMutator<WellSampleData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asWell().removeWellSample(m.nextDeletion().asWellSample());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asWell().addWellSample(m.nextAddition().asWellSample());
        }
        this.wellSamples = m.result();
    }
}

