/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class LiteralValueSource
extends ValueSource {
    protected final String string;
    public static final int hash = LiteralValueSource.class.hashCode();

    public LiteralValueSource(String string) {
        this.string = string;
    }

    public String getValue() {
        return this.string;
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new DocValues(){

            public String strVal(int doc) {
                return LiteralValueSource.this.string;
            }

            public String toString(int doc) {
                return LiteralValueSource.this.string;
            }
        };
    }

    public String description() {
        return "literal(" + this.string + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralValueSource)) {
            return false;
        }
        LiteralValueSource that = (LiteralValueSource)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return hash + this.string.hashCode();
    }
}

