/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetImpl;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionHelper;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointDatasetImpl
extends FeatureDatasetImpl
implements FeatureDatasetPoint {
    protected List<DsgFeatureCollection> collectionList;
    protected FeatureType featureType;

    protected PointDatasetImpl(FeatureType featureType) {
        this.featureType = featureType;
    }

    protected PointDatasetImpl(PointDatasetImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
        super(from);
        this.collectionList = from.collectionList;
        this.featureType = from.featureType;
        if (filter_bb == null) {
            this.boundingBox = from.boundingBox;
        } else {
            LatLonRect latLonRect = this.boundingBox = from.boundingBox == null ? filter_bb : from.boundingBox.intersect(filter_bb);
        }
        this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
    }

    public PointDatasetImpl(NetcdfDataset ds, FeatureType featureType) {
        super(ds);
        this.featureType = featureType;
    }

    protected void setPointFeatureCollection(List<DsgFeatureCollection> collectionList) {
        this.collectionList = collectionList;
    }

    protected void setPointFeatureCollection(DsgFeatureCollection collection) {
        this.collectionList = Lists.newArrayList((Object[])new DsgFeatureCollection[]{collection});
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    protected void setFeatureType(FeatureType ftype) {
        this.featureType = ftype;
    }

    @Override
    public List<DsgFeatureCollection> getPointFeatureCollectionList() {
        return this.collectionList;
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        super.getDetailInfo(sf);
        int count = 0;
        for (DsgFeatureCollection pfc : this.collectionList) {
            sf.format("%nPointFeatureCollection %d %n", count);
            sf.format(" %s %s %n", new Object[]{pfc.getCollectionFeatureType(), pfc.getName()});
            sf.format("   npts = %d %n", pfc.size());
            sf.format("   timeUnit = %s %n", pfc.getTimeUnit());
            sf.format("    altUnit = %s %n", pfc.getAltUnits());
            ++count;
        }
    }

    @Override
    public void calcBounds(Formatter sf) {
        for (DsgFeatureCollection pfc : this.collectionList) {
            try {
                CollectionInfo info = new DsgCollectionHelper(pfc).calcBounds();
                sf.format("     bb = %s %n", info.bbox == null ? "" : info.bbox.toString2());
                sf.format("  dates = %s %n", info.getCalendarDateRange(pfc.getTimeUnit()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

