/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.util.Assert;

public final class LdapUtils {
    private static final Log logger = LogFactory.getLog(LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeContext(Context ctx) {
        if (ctx instanceof DirContextAdapter) {
            return;
        }
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to close context.", (Throwable)e);
        }
    }

    public static void closeEnumeration(NamingEnumeration ne) {
        try {
            if (ne != null) {
                ne.close();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to close enumeration.", (Throwable)e);
        }
    }

    public static String getRelativeName(String fullDn, Context baseCtx) throws NamingException {
        String baseDn = baseCtx.getNameInNamespace();
        if (baseDn.length() == 0) {
            return fullDn;
        }
        DistinguishedName base = new DistinguishedName(baseDn);
        DistinguishedName full = new DistinguishedName(fullDn);
        if (base.equals((Object)full)) {
            return "";
        }
        Assert.isTrue((boolean)full.startsWith((Name)base), (String)"Full DN does not start with base DN");
        full.removeFirst((Name)base);
        return full.toString();
    }

    public static DistinguishedName getFullDn(DistinguishedName dn, Context baseCtx) throws NamingException {
        DistinguishedName baseDn = new DistinguishedName(baseCtx.getNameInNamespace());
        if (dn.contains(baseDn)) {
            return dn;
        }
        baseDn.append(dn);
        return baseDn;
    }

    public static String convertPasswordToString(Object passObj) {
        Assert.notNull((Object)passObj, (String)"Password object to convert must not be null");
        if (passObj instanceof byte[]) {
            return Utf8.decode((byte[])((byte[])passObj));
        }
        if (passObj instanceof String) {
            return (String)passObj;
        }
        throw new IllegalArgumentException("Password object was not a String or byte array.");
    }

    public static String parseRootDnFromUrl(String url) {
        String urlRootDn;
        Assert.hasLength((String)url, (String)"url must have length");
        if (url.startsWith("ldap:") || url.startsWith("ldaps:")) {
            URI uri = LdapUtils.parseLdapUrl(url);
            urlRootDn = uri.getRawPath();
        } else {
            urlRootDn = url;
        }
        if (urlRootDn.startsWith("/")) {
            urlRootDn = urlRootDn.substring(1);
        }
        return urlRootDn;
    }

    private static URI parseLdapUrl(String url) {
        Assert.hasLength((String)url, (String)"url must have length");
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to parse url: " + url);
            iae.initCause(e);
            throw iae;
        }
    }
}

