/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import loci.common.Location;
import loci.formats.ResourceNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeImage.class);
    private Location directoryRoot;
    private ResourceNamer resourceNamer;

    public FakeImage(Location directoryRoot) {
        this.directoryRoot = directoryRoot;
    }

    public static void isValidRange(int arg, int min, int max) {
        if (arg < min || arg > max) {
            throw new IllegalArgumentException("Method argument value outside valid range.");
        }
    }

    public Location generateScreen(int plates, int plateAcquisitions, int rows, int columns, int fields) {
        FakeImage.isValidRange(plates, 1, 255);
        FakeImage.isValidRange(plateAcquisitions, 1, 255);
        FakeImage.isValidRange(rows, 1, 255);
        FakeImage.isValidRange(columns, 1, 255);
        FakeImage.isValidRange(fields, 1, 255);
        ArrayList<Location> paths = new ArrayList<Location>();
        this.resourceNamer = new ResourceNamer(rows);
        long start = System.currentTimeMillis();
        for (int i = 0; i < plates; ++i) {
            Location plateLocation = this.resourceNamer.getLocationFromResourceName(this.directoryRoot, "Plate", i, File.separator);
            for (int j = 0; j < plateAcquisitions; ++j) {
                Location plateAcquisitionLocation = this.resourceNamer.getLocationFromResourceName(plateLocation, "Run", j, File.separator);
                this.resourceNamer.restartAlphabet();
                for (int k = 0; k < rows; ++k) {
                    for (int l = 0; l < columns; ++l) {
                        Location wellLocation = this.resourceNamer.getLocationFromResourceName(plateAcquisitionLocation, "Well" + this.resourceNamer.getLetter(), l, File.separator);
                        paths.add(wellLocation);
                    }
                    this.resourceNamer.nextLetter();
                }
            }
        }
        for (Location path : paths) {
            if (!path.mkdirs()) continue;
            for (int i = 0; i < fields; ++i) {
                Location fieldLocation = this.resourceNamer.getLocationFromResourceName(path, "Field", i, "fake");
                try {
                    fieldLocation.createNewFile();
                    LOGGER.debug("Created: " + fieldLocation.getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.debug(String.format("Fake SPW structure generation took %s ms.", end - start));
        return this.directoryRoot;
    }
}

