/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSpatialTypeOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;

public class SqlOperatorTables {
    private static final java.util.function.Supplier<SqlOperatorTable> SPATIAL = () -> ((Supplier)Suppliers.memoize(SqlSpatialTypeOperatorTable::new)).get();

    private SqlOperatorTables() {
    }

    public static SqlOperatorTable spatialInstance() {
        return SPATIAL.get();
    }

    public static SqlOperatorTable chain(Iterable<SqlOperatorTable> tables) {
        ArrayList<SqlOperatorTable> list = new ArrayList<SqlOperatorTable>();
        for (SqlOperatorTable table : tables) {
            SqlOperatorTables.addFlattened(list, table);
        }
        if (list.size() == 1) {
            return (SqlOperatorTable)list.get(0);
        }
        return new ChainedSqlOperatorTable((ImmutableList<SqlOperatorTable>)ImmutableList.copyOf(list));
    }

    private static void addFlattened(List<SqlOperatorTable> list, SqlOperatorTable table) {
        if (table instanceof ChainedSqlOperatorTable) {
            ChainedSqlOperatorTable chainedTable = (ChainedSqlOperatorTable)table;
            for (SqlOperatorTable table2 : chainedTable.tableList) {
                SqlOperatorTables.addFlattened(list, table2);
            }
        } else if (!(table instanceof ImmutableListSqlOperatorTable) || !table.getOperatorList().isEmpty()) {
            list.add(table);
        }
    }

    public static SqlOperatorTable chain(SqlOperatorTable ... tables) {
        return SqlOperatorTables.chain((Iterable<SqlOperatorTable>)ImmutableList.copyOf((Object[])tables));
    }

    public static SqlOperatorTable of(Iterable<? extends SqlOperator> list) {
        return new ImmutableListSqlOperatorTable((ImmutableList<SqlOperator>)ImmutableList.copyOf(list));
    }

    public static SqlOperatorTable of(SqlOperator ... operators) {
        return SqlOperatorTables.of((Iterable<? extends SqlOperator>)ImmutableList.copyOf((Object[])operators));
    }

    private static class ImmutableListSqlOperatorTable
    extends ListSqlOperatorTable {
        ImmutableListSqlOperatorTable(ImmutableList<SqlOperator> operatorList) {
            super((List<SqlOperator>)operatorList, false);
        }
    }
}

