/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.api.client.util.Key;
import io.minio.errors.InvalidArgumentException;
import io.minio.messages.FilterRule;
import io.minio.messages.XmlEntity;
import java.util.LinkedList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class S3Key
extends XmlEntity {
    @Key(value="FilterRule")
    private List<FilterRule> filterRuleList = new LinkedList<FilterRule>();

    public S3Key() throws XmlPullParserException {
        this.name = "S3Key";
    }

    public List<FilterRule> filterRuleList() {
        return this.filterRuleList;
    }

    private void setRule(String name, String value) throws InvalidArgumentException, XmlPullParserException {
        if (value.length() > 1024) {
            throw new InvalidArgumentException("value '" + value + "' is more than 1024 long");
        }
        for (FilterRule rule : this.filterRuleList) {
            if (!rule.name().equals(name)) continue;
            this.filterRuleList.remove((Object)rule);
        }
        FilterRule newRule = new FilterRule();
        newRule.setName(name);
        newRule.setValue(value);
        this.filterRuleList.add(newRule);
    }

    public void setPrefixRule(String value) throws InvalidArgumentException, XmlPullParserException {
        this.setRule("prefix", value);
    }

    public void setSuffixRule(String value) throws InvalidArgumentException, XmlPullParserException {
        this.setRule("suffix", value);
    }
}

