/*
 * Decompiled with CFR 0.152.
 */
package io.minio.http;

public enum Scheme {
    HTTP("http"),
    HTTPS("https");

    private final String value;

    private Scheme(String value) {
        this.value = value;
    }

    public static Scheme fromString(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("null scheme");
        }
        for (Scheme s : Scheme.values()) {
            if (!scheme.equalsIgnoreCase(s.value)) continue;
            return s;
        }
        throw new IllegalArgumentException("invalid HTTP scheme '" + scheme + "'");
    }
}

