/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import ome.security.auth.ConfigurablePasswordProvider;
import ome.security.auth.PasswordUtil;
import ome.util.Utils;
import org.springframework.util.Assert;

public class FilePasswordProvider
extends ConfigurablePasswordProvider {
    protected final File file;

    public FilePasswordProvider(PasswordUtil util, File file) {
        super(util);
        this.file = file;
        Assert.notNull((Object)file);
    }

    public FilePasswordProvider(PasswordUtil util, File file, boolean ignoreUnknown) {
        super(util, ignoreUnknown);
        this.file = file;
        Assert.notNull((Object)file);
    }

    @Override
    public boolean hasPassword(String user) {
        Properties p = this.getProperties();
        return p.containsKey(user);
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        Properties p = this.getProperties();
        return this.loginAttempt(user, this.doCheckPassword(user, password, p, readOnly));
    }

    protected Boolean doCheckPassword(String user, String password, Properties p, boolean readOnly) {
        if (!p.containsKey(user)) {
            return super.checkPassword(user, password, readOnly);
        }
        String currentPassword = p.getProperty(user);
        return this.comparePasswords(currentPassword, password);
    }

    protected Properties getProperties() {
        Properties properties;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            p.load(fis);
            properties = p;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Could not read file: " + this.file);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(fis);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)fis);
        return properties;
    }
}

