/*
 * Decompiled with CFR 0.152.
 */
package ome.services.procs;

import ome.api.IQuery;
import ome.api.ITypes;
import ome.api.IUpdate;
import ome.model.jobs.Job;
import ome.services.procs.Process;
import ome.services.procs.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorSkeleton
implements Processor {
    private static Logger log = LoggerFactory.getLogger(ProcessorSkeleton.class);
    private IQuery query;
    private ITypes types;
    private IUpdate update;

    public void setQueryService(IQuery queryService) {
        this.query = queryService;
    }

    public void setTypesService(ITypes typesService) {
        this.types = typesService;
    }

    public void setUpdateService(IUpdate updateService) {
        this.update = updateService;
    }

    @Override
    public Process process(long id) {
        Job job = this.lookup(id);
        if (this.accept(job)) {
            return this.process(job);
        }
        return null;
    }

    public Job lookup(long id) {
        return (Job)this.query.find(Job.class, id);
    }

    public boolean accept(Job job) {
        return false;
    }

    public Process process(Job job) {
        return null;
    }
}

