/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.lang.reflect.Constructor;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.services.query.IObjectClassQuery;
import ome.services.query.Query;
import ome.services.query.QuerySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassQuerySource
extends QuerySource {
    private static Logger log = LoggerFactory.getLogger(ClassQuerySource.class);

    public Query lookup(String queryID, Parameters parameters) {
        Query q = null;
        Class<?> klass = null;
        try {
            klass = Class.forName(queryID);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (klass == null) {
            return null;
        }
        if (Query.class.isAssignableFrom(klass)) {
            try {
                Constructor<?> c = klass.getConstructor(Parameters.class);
                q = (Query)c.newInstance(parameters);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Query could not be instanced.", e.getCause());
                }
                throw new RuntimeException("Error while trying to instantiate:" + queryID, e);
            }
            return q;
        }
        if (IObject.class.isAssignableFrom(klass)) {
            Parameters p = new Parameters(parameters);
            p.addClass(klass);
            return new IObjectClassQuery(p);
        }
        return null;
    }
}

