/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.io.Serializable;
import java.util.HashMap;
import ome.api.local.LocalQuery;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.model.meta.Experimenter;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.parameters.Parameters;
import ome.security.NodeProvider;
import ome.services.sessions.SessionProvider;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class SessionProviderInDb
implements SessionProvider,
ReadOnlyStatus.IsAware {
    private static final Logger log = LoggerFactory.getLogger(SessionProviderInDb.class);
    private final Roles roles;
    private final NodeProvider nodeProvider;
    private final Executor executor;
    private final SqlAction sqlAction;

    public SessionProviderInDb(Roles roles, NodeProvider nodeProvider, Executor executor, SqlAction sqlAction) {
        this.roles = roles;
        this.nodeProvider = nodeProvider;
        this.executor = executor;
        this.sqlAction = sqlAction;
    }

    @Override
    public Session executeUpdate(ServiceFactory sf, Session session, String uuid, long userId, Long sudoerId) {
        Node node = this.nodeProvider.getManagerByUuid(uuid, sf);
        if (node == null) {
            node = new Node(Long.valueOf(0L), false);
        }
        session.setNode(node);
        session.setOwner(new Experimenter(Long.valueOf(userId), false));
        if (sudoerId == null) {
            session.setSudoer(null);
        } else {
            session.setSudoer(new Experimenter(sudoerId, false));
        }
        String userIP = session.getUserIP();
        Session rv = (Session)sf.getUpdateService().saveAndReturnObject((IObject)session);
        if (userIP != null) {
            this.sqlAction.updateSessionUserIP(rv.getId().longValue(), userIP);
        }
        rv.putAt("#2733", session.retrieve("#2733"));
        return rv;
    }

    @Override
    public void executeCloseSession(final String uuid) {
        this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeCloseSession", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                try {
                    int count = sql.closeSessions(uuid);
                    if (count == 0) {
                        log.warn("No session updated on closeSession: {}", (Object)uuid);
                    } else {
                        log.debug("Session.closed set to now() for {}", (Object)uuid);
                    }
                }
                catch (Exception e) {
                    log.error("FAILED TO CLOSE SESSION IN DATABASE: {}", (Object)uuid, (Object)e);
                }
                return null;
            }
        });
    }

    @Override
    public Session executeInternalSession(final String uuid, final Session session) {
        final Long sessionId = this.executeNextSessionId();
        return (Session)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeInternalSession", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                long nodeId = SessionProviderInDb.this.nodeProvider.getManagerIdByUuid(uuid, sql);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("sid", sessionId);
                params.put("ttl", session.getTimeToLive());
                params.put("tti", session.getTimeToIdle());
                params.put("start", session.getStarted());
                params.put("type", session.getDefaultEventType());
                params.put("uuid", session.getUuid());
                params.put("node", nodeId);
                params.put("owner", SessionProviderInDb.this.roles.getRootId());
                params.put("agent", session.getUserAgent());
                params.put("ip", session.getUserIP());
                int count = sql.insertSession(params);
                if (count == 0) {
                    throw new InternalException("Failed to insert new session: " + session.getUuid());
                }
                Long id = sql.sessionId(session.getUuid());
                session.setNode(new Node(Long.valueOf(nodeId), false));
                session.setOwner(new Experimenter(Long.valueOf(SessionProviderInDb.this.roles.getRootId()), false));
                session.setId(id);
                return session;
            }
        });
    }

    @Override
    public long executeNextSessionId() {
        return (Long)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeNextSessionId", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                return sql.nextSessionId();
            }
        });
    }

    @Override
    public Session findSessionById(long id, org.hibernate.Session session) {
        return (Session)session.get(Session.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public Session findSessionById(long id, ServiceFactory sf) {
        LocalQuery iQuery = (LocalQuery)sf.getQueryService();
        String sessionClass = iQuery.find(Share.class, id) == null ? "Session" : "Share";
        return (Session)iQuery.findByQuery("select s from " + sessionClass + " s left outer join fetch s.sudoer left outer join fetch s.annotationLinks l left outer join fetch l.child a where s.id = :id", new Parameters().addId(Long.valueOf(id)).cache());
    }

    @Override
    public Long findSessionIdByUuid(String uuid, ServiceFactory sf) {
        Session session = (Session)sf.getQueryService().findByString(Session.class, "uuid", uuid);
        return session == null ? null : session.getId();
    }

    @Override
    public Long findSessionIdByUuid(final String uuid) {
        return (Long)this.executor.executeSql(new Executor.SimpleSqlWork(this, "getSessionId", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                try {
                    return sql.sessionId(uuid);
                }
                catch (EmptyResultDataAccessException erdae) {
                    return null;
                }
            }
        });
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return readOnly.isReadOnlyDb();
    }
}

