/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sharing;

import Ice.Communicator;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.OutputStream;
import Ice.ReadObjectCallback;
import Ice.UnmarshalOutOfBoundsException;
import Ice.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ValidationException;
import ome.model.IObject;
import ome.model.meta.Share;
import ome.services.sharing.data.Obj;
import ome.services.sharing.data.ShareData;
import ome.services.sharing.data.ShareItem;
import ome.services.util.IceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShareStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Communicator ic = Util.initialize();

    public ShareData getShareIfAccessible(long shareId, boolean isAdmin, long userId) {
        ShareData data = this.get(shareId);
        if (data == null) {
            return null;
        }
        if (data.owner == userId || data.members.contains(userId) || isAdmin) {
            return data;
        }
        return null;
    }

    public <T extends IObject> ShareData set(Share share, long owner, List<T> objects, List<Long> members, List<String> guests, boolean enabled) {
        ShareData data = new ShareData();
        data.id = share.getId();
        data.owner = owner;
        data.members = new ArrayList<Long>(members);
        data.guests = new ArrayList<String>(guests);
        data.enabled = enabled;
        data.objectMap = this.map(objects);
        data.objectList = this.list(data.objectMap);
        List<ShareItem> shareItems = this.asItems(share.getId(), data.objectList, members, guests);
        this.doSet(share, data, shareItems);
        return data;
    }

    public void update(Share share, ShareData data) {
        List<ShareItem> shareItems = this.asItems(data);
        this.doSet(share, data, shareItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] parse(ShareData data) {
        OutputStream os = IceUtil.createSafeOutputStream(this.ic);
        byte[] bytes = null;
        try {
            os.writeObject((Ice.Object)data);
            os.writePendingObjects();
            bytes = os.finished();
        }
        finally {
            os.destroy();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ShareData parse(long id, byte[] data) {
        if (data == null) {
            return null;
        }
        InputStream is = IceUtil.createSafeInputStream(this.ic, data);
        final ShareData[] shareData = new ShareData[1];
        try {
            is.readObject(new ReadObjectCallback(){

                public void invoke(Ice.Object arg0) {
                    shareData[0] = (ShareData)arg0;
                }
            });
            is.readPendingObjects();
        }
        catch (UnmarshalOutOfBoundsException oob) {
            this.log.error("Share " + id + " is malformed. Creating empty share.");
            shareData[0] = new ShareData(id, -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), false, 0L);
        }
        catch (MarshalException me) {
            this.log.warn("Share " + id + " cannot be unmarshalled. Returning null.");
            ShareData shareData2 = null;
            return shareData2;
        }
        finally {
            is.destroy();
        }
        return shareData[0];
    }

    public final void init() {
        this.doInit();
        Long mapsize = this.totalShares();
        Long itemssize = this.totalSharedItems();
        this.log.info("Loaded store " + this + " with " + mapsize + " shares and " + itemssize + " objects");
    }

    public final void close() {
        try {
            this.doClose();
        }
        finally {
            this.ic.destroy();
        }
    }

    public final <T extends IObject> boolean contains(long sessionId, Class<T> kls, long objId) {
        return this.doContains(sessionId, kls, objId);
    }

    public abstract void doInit();

    public abstract Long totalShares();

    public abstract Long totalSharedItems();

    public abstract Set<Long> keys();

    public abstract ShareData get(long var1);

    public abstract List<ShareData> getShares(long var1, boolean var3, boolean var4);

    public abstract <T extends IObject> boolean doContains(long var1, Class<T> var3, long var4);

    public abstract void doSet(Share var1, ShareData var2, List<ShareItem> var3);

    public abstract void doClose();

    private <T extends IObject> List<ShareItem> asItems(long share, List<Obj> items, List<Long> members, List<String> guests) {
        ArrayList<ShareItem> shareItems = new ArrayList<ShareItem>(items.size());
        for (Obj item : items) {
            ShareItem shareItem = new ShareItem();
            shareItem.share = share;
            shareItem.id = item.id;
            shareItem.type = item.type;
            shareItem.members = new ArrayList<Long>(members);
            shareItem.guests = new ArrayList<String>(guests);
            shareItems.add(shareItem);
        }
        return shareItems;
    }

    private <T extends IObject> List<ShareItem> asItems(ShareData data) {
        Map<String, List<Long>> map = data.objectMap;
        ArrayList<ShareItem> shareItems = new ArrayList<ShareItem>();
        for (String type : map.keySet()) {
            for (Long id : map.get(type)) {
                ShareItem shareItem = new ShareItem();
                shareItem.share = data.id;
                shareItem.id = id;
                shareItem.type = type;
                shareItem.members = data.members;
                shareItem.guests = data.guests;
                shareItems.add(shareItem);
            }
        }
        return shareItems;
    }

    private <T extends IObject> Map<String, List<Long>> map(List<T> items) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (IObject t : items) {
            String kls = t.getClass().getName();
            ArrayList<Long> ids = (ArrayList<Long>)map.get(kls);
            if (ids == null) {
                ids = new ArrayList<Long>();
                map.put(kls, ids);
            }
            if (ids.contains(t.getId())) continue;
            ids.add(t.getId());
        }
        return map;
    }

    private List<Obj> list(Map<String, List<Long>> items) {
        ArrayList<Obj> objList = new ArrayList<Obj>();
        for (String key : items.keySet()) {
            List<Long> ids = items.get(key);
            for (Long id : ids) {
                if (id == null) {
                    throw new ValidationException("Cannot add object with null id!");
                }
                Obj obj = new Obj();
                obj.type = key;
                obj.id = id;
                objList.add(obj);
            }
        }
        return objList;
    }
}

