/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.lut;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import omeis.providers.re.lut.LutReader;

class TextLutReader
extends LutReader {
    private int rows = 0;
    private int columns = 1;
    private String firstTok;

    private void countLines(Reader r) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        int wordsPerRow = 0;
        int wordsInPreviousRow = 0;
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 127);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(128, 255);
        tok.eolIsSignificant(true);
        while (tok.nextToken() != -1) {
            switch (tok.ttype) {
                case 10: {
                    ++this.rows;
                    if (wordsPerRow == 0) {
                        --this.rows;
                    }
                    if (this.rows == 1 && wordsPerRow > 0) {
                        this.columns = wordsPerRow;
                    }
                    if (this.rows > 1 && wordsPerRow != 0 && wordsPerRow != wordsInPreviousRow) {
                        throw new IOException("Row " + this.rows + " is not the same length as the first row.");
                    }
                    if (wordsPerRow != 0) {
                        wordsInPreviousRow = wordsPerRow;
                    }
                    wordsPerRow = 0;
                    break;
                }
                case -3: {
                    ++wordsPerRow;
                }
            }
        }
        if (wordsPerRow == this.columns) {
            ++this.rows;
        }
    }

    private double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private void read(Reader r, float[] pixels) throws IOException {
        int size = pixels.length;
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 127);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(128, 255);
        int i = 0;
        int inc = size / 20;
        if (inc < 1) {
            inc = 1;
        }
        while (tok.nextToken() != -1) {
            if (tok.ttype != -3) continue;
            if (i == 0) {
                this.firstTok = tok.sval;
            }
            pixels[i++] = (float)this.parseDouble(tok.sval, Double.NaN);
            if (i != size) continue;
            break;
        }
    }

    TextLutReader(File f) {
        super(f);
    }

    private float[] crop(int x, int y, int w, int h, float[] pixels) {
        float[] pixels2 = new float[w * h];
        for (int ys = y; ys < y + h; ++ys) {
            int offset1 = (ys - y) * w;
            int offset2 = ys * this.columns + x;
            for (int xs = 0; xs < w; ++xs) {
                pixels2[offset1++] = pixels[offset2++];
            }
        }
        return pixels2;
    }

    @Override
    int read() throws Exception {
        String path = this.file.getAbsolutePath();
        BufferedReader r = new BufferedReader(new FileReader(path));
        this.countLines(r);
        ((Reader)r).close();
        r = new BufferedReader(new FileReader(path));
        if (this.columns * this.rows == 0) {
            return 0;
        }
        int height = this.rows;
        float[] pixels = new float[this.columns * height];
        this.read(r, pixels);
        ((Reader)r).close();
        int firstRowNaNCount = 0;
        for (int i = 0; i < this.columns; ++i) {
            if (i >= pixels.length || !Float.isNaN(pixels[i])) continue;
            ++firstRowNaNCount;
        }
        float[] values = pixels;
        if (firstRowNaNCount == this.columns && !"NaN".equals(this.firstTok) && !"nan".equals(this.firstTok)) {
            height = this.rows - 1;
            values = this.crop(0, 1, this.columns, height, pixels);
        }
        if (this.columns < 3 || this.columns > 4 || height < 256 || height > 258) {
            return 0;
        }
        int x = this.columns == 4 ? 1 : 0;
        int y = height > 256 ? 1 : 0;
        float[] result = this.crop(x, y, 3, 256, values);
        this.columns = 3;
        for (int i = 0; i < 256; ++i) {
            this.reds[i] = (byte)result[i * this.columns];
            this.greens[i] = (byte)result[i * this.columns + 1];
            this.blues[i] = (byte)result[i * this.columns + 2];
        }
        return 256;
    }
}

