/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.h5ar.HDF5Archiver;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5ArchiveReader;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5Archiver;
import java.io.File;

public class HDF5ArchiverFactory {
    public static IHDF5Archiver open(File file) {
        return new HDF5Archiver(file, false);
    }

    public static IHDF5Archiver open(File file, IErrorStrategy errorStrategyOrNull) {
        return new HDF5Archiver(file, false, false, IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_V1_8, errorStrategyOrNull);
    }

    public static IHDF5Archiver open(File file, boolean noSync, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormat, IErrorStrategy errorStrategyOrNull) {
        return new HDF5Archiver(file, false, noSync, fileFormat, errorStrategyOrNull);
    }

    public static IHDF5Archiver open(String filePath) {
        return new HDF5Archiver(new File(filePath), false);
    }

    public static IHDF5Archiver open(String filePath, IErrorStrategy errorStrategyOrNull) {
        return new HDF5Archiver(new File(filePath), false, false, IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_V1_8, errorStrategyOrNull);
    }

    public static IHDF5Archiver open(String filePath, boolean noSync, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormat, IErrorStrategy errorStrategyOrNull) {
        return new HDF5Archiver(new File(filePath), false, noSync, fileFormat, errorStrategyOrNull);
    }

    public static IHDF5Archiver open(IHDF5Writer writer) {
        return new HDF5Archiver(writer, false, null);
    }

    public static IHDF5Archiver open(IHDF5Writer writer, IErrorStrategy errorStrategy) {
        return new HDF5Archiver(writer, false, errorStrategy);
    }

    public static IHDF5ArchiveReader openForReading(File file) {
        return new HDF5Archiver(file, true);
    }

    public static IHDF5ArchiveReader openForReading(File file, IErrorStrategy errorStrategy) {
        return new HDF5Archiver(file, true, true, IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_V1_8, errorStrategy);
    }

    public static IHDF5ArchiveReader openForReading(String filePath) {
        return new HDF5Archiver(new File(filePath), true);
    }

    public static IHDF5ArchiveReader openForReading(String filePath, IErrorStrategy errorStrategy) {
        return new HDF5Archiver(new File(filePath), true, true, IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_V1_8, errorStrategy);
    }

    public static IHDF5ArchiveReader openForReading(IHDF5Reader reader, IErrorStrategy errorStrategy) {
        return new HDF5Archiver(reader, true, errorStrategy);
    }

    public static IHDF5ArchiveReader openForReading(IHDF5Reader reader) {
        return new HDF5Archiver(reader, true, null);
    }
}

