/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.hdf5lib;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5O_info_t;

public class HDFHelper {
    static final boolean USE_NATIVE_METHODS = true;
    static final int pointerSize = HDFHelper.getPointerSize();

    private static native boolean _H5Lexists(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean H5Lexists(long loc_id, String name, long lapl_id) throws HDF5LibraryException, NullPointerException {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return HDFHelper._H5Lexists(loc_id, name, lapl_id);
        }
    }

    public static H5O_info_t H5Oget_info_by_name(long loc_id, String object_name, boolean exceptionIfNonExistent) {
        try {
            return H5.H5Oget_info_by_name(loc_id, object_name, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException e) {
            if (e.getMinorErrorNumber() == HDF5Constants.H5E_NOTFOUND || e.getMinorErrorNumber() == HDF5Constants.H5E_CANTINSERT) {
                if (exceptionIfNonExistent) {
                    throw e;
                }
            } else {
                throw e;
            }
            return new H5O_info_t(-1L, -1L, -1, -1, -1L, -1L, -1L, -1L, -1L, null, null, null);
        }
    }

    private static native int _H5Lget_link_info(long var0, String var2, String[] var3) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int H5Lget_link_info(long fileId, String objectName, String[] linkTargetOrNull, boolean exceptionIfNonExistent) {
        int result = -1;
        try {
            Class<H5> clazz = H5.class;
            synchronized (H5.class) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return HDFHelper._H5Lget_link_info(fileId, objectName, linkTargetOrNull);
            }
        }
        catch (HDF5LibraryException e) {
            if (e.getMinorErrorNumber() == HDF5Constants.H5E_NOTFOUND || e.getMinorErrorNumber() == HDF5Constants.H5E_CANTINSERT) {
                if (exceptionIfNonExistent) {
                    System.err.println("Ups, throwing exception " + e + " anyway");
                    throw e;
                }
            } else {
                throw e;
            }
            return result;
        }
    }

    private static String[] getLinkTarget(long locId, String objectName, int type) {
        String[] linkTarget = new String[2];
        H5.H5Lget_value(locId, objectName, linkTarget, HDF5Constants.H5P_DEFAULT);
        if (type == HDF5Constants.H5L_TYPE_SOFT || type == HDF5Constants.H5L_TYPE_EXTERNAL) {
            return linkTarget;
        }
        throw new HDF5Exception("No Link: " + objectName);
    }

    private static void getLinkTargetByIdx(long locId, String objectName, int idx, int type, String[] linkTarget) {
        H5.H5Lget_value_by_idx(locId, objectName, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, idx, linkTarget, HDF5Constants.H5P_DEFAULT);
        if (type != HDF5Constants.H5L_TYPE_SOFT && type != HDF5Constants.H5L_TYPE_EXTERNAL) {
            throw new HDF5Exception("No Link: " + objectName);
        }
    }

    private static native int _H5Lget_link_names_all(long var0, String var2, String[] var3, int var4) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void H5Lget_link_names_all(long locId, String groupName, String[] objectNames) {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            HDFHelper._H5Lget_link_names_all(locId, groupName, objectNames, objectNames.length);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private static native int _H5Lget_link_info_all(long var0, String var2, String[] var3, int[] var4, String[] var5, String[] var6, int var7) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void H5Lget_link_info_all(long locId, String groupName, String[] objectNames, int[] objectTypes, String[] linkFilenamesOrNull, String[] linkTargetsOrNull) {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            HDFHelper._H5Lget_link_info_all(locId, groupName, objectNames, objectTypes, linkTargetsOrNull, linkFilenamesOrNull, objectNames.length);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    public static native int getPointerSize();

    public static int getMachineWordSize() {
        return pointerSize;
    }

    public static native int compoundCpyVLStr(String var0, byte[] var1, int var2);

    public static native String createVLStrFromCompound(byte[] var0, int var1);

    public static native int freeCompoundVLStr(byte[] var0, int var1, int[] var2);

    private static native long _H5Pcreate_xfer_abort_overflow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long H5Pcreate_xfer_abort_overflow() {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return HDFHelper._H5Pcreate_xfer_abort_overflow();
        }
    }

    private static native long _H5Pcreate_xfer_abort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long H5Pcreate_xfer_abort() {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return HDFHelper._H5Pcreate_xfer_abort();
        }
    }

    private static native long _H5Pset_mdc_image_config(long var0, boolean var2) throws HDF5LibraryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long H5Pset_mdc_image_config(long fapl, boolean generate_image) throws HDF5LibraryException {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return HDFHelper._H5Pset_mdc_image_config(fapl, generate_image);
        }
    }

    private static native boolean _H5Pget_mdc_image_enabled(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean H5Pget_mdc_image_enabled(long fapl) {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return HDFHelper._H5Pget_mdc_image_enabled(fapl);
        }
    }

    private static native boolean _H5Fhas_mdc_image(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean H5Fhas_mdc_image(long file_id) {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return HDFHelper._H5Fhas_mdc_image(file_id);
        }
    }

    public static boolean H5Fhas_mdc_image(String file_path) {
        long fileId = -1L;
        try {
            fileId = H5.H5Fopen(file_path, HDF5Constants.H5F_ACC_RDONLY, HDF5Constants.H5P_DEFAULT);
            boolean bl = HDFHelper.H5Fhas_mdc_image(fileId);
            return bl;
        }
        finally {
            if (fileId != -1L) {
                H5.H5Fclose(fileId);
            }
        }
    }

    public static double[] byteToDouble(byte[] data, int start, int len) {
        return HDFNativeData.byteToDouble(start, len, data);
    }

    public static float[] byteToFloat(byte[] data, int start, int len) {
        return HDFNativeData.byteToFloat(start, len, data);
    }

    public static int[] byteToInt(byte[] data, int start, int len) {
        return HDFNativeData.byteToInt(start, len, data);
    }

    public static long[] byteToLong(byte[] data, int start, int len) {
        return HDFNativeData.byteToLong(start, len, data);
    }

    public static short[] byteToShort(byte[] data, int start, int len) {
        return HDFNativeData.byteToShort(start, len, data);
    }

    public static byte[] doubleToByte(double[] data) {
        return HDFNativeData.doubleToByte(0, data.length, data);
    }

    public static byte[] floatToByte(float[] data) {
        return HDFNativeData.floatToByte(0, data.length, data);
    }

    public static byte[] intToByte(int[] data) {
        return HDFNativeData.intToByte(0, data.length, data);
    }

    public static byte[] longToByte(long[] data) {
        return HDFNativeData.longToByte(0, data.length, data);
    }

    public static byte[] shortToByte(short[] data) {
        return HDFNativeData.shortToByte(0, data.length, data);
    }
}

