/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.security.SecureAction;
import ome.security.SecuritySystem;
import ome.security.auth.RoleProvider;
import ome.tools.hibernate.HibernateUtils;
import ome.tools.hibernate.SecureMerge;
import ome.tools.hibernate.SessionFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRoleProvider
implements RoleProvider {
    private static final Logger log = LoggerFactory.getLogger(SimpleRoleProvider.class);
    protected final SecuritySystem sec;
    protected final SessionFactory sf;
    private AtomicBoolean ignoreCaseLookup;

    public SimpleRoleProvider(SecuritySystem sec, SessionFactory sf) {
        this(sec, sf, new AtomicBoolean(false));
    }

    public SimpleRoleProvider(SecuritySystem sec, SessionFactory sf, AtomicBoolean ignoreCaseLookup) {
        this.sec = sec;
        this.sf = sf;
        this.ignoreCaseLookup = ignoreCaseLookup;
    }

    @Override
    public String nameById(long id) {
        Session s = this.sf.getSession();
        return (String)s.createQuery("select omeName from Experimenter where id = :id").setParameter("id", (Object)id).uniqueResult();
    }

    @Override
    public long createGroup(String name, Permissions perms, boolean strict) {
        return this.createGroup(name, perms, strict, false);
    }

    @Override
    public long createGroup(String name, Permissions perms, boolean strict, boolean isLdap) {
        Session s = this.sf.getSession();
        ExperimenterGroup g = this.groupByName(name, s);
        if (g == null) {
            g = new ExperimenterGroup();
            g.setName(name);
            g.setLdap(Boolean.valueOf(isLdap));
            if (perms == null) {
                perms = Permissions.USER_PRIVATE;
            }
            g.getDetails().setPermissions(perms);
            g = (ExperimenterGroup)s.merge((Object)g);
        } else if (strict) {
            throw new ValidationException("Group already exists: " + name);
        }
        return g.getId();
    }

    @Override
    public long createGroup(ExperimenterGroup group) {
        if ((group = this.copyGroup(group)).getDetails().getPermissions() == null) {
            group.getDetails().setPermissions(Permissions.USER_PRIVATE);
        }
        Session session = this.sf.getSession();
        ExperimenterGroup g = (ExperimenterGroup)this.sec.doAction(new SecureMerge(session), (IObject[])new ExperimenterGroup[]{group});
        return g.getId();
    }

    @Override
    public long createExperimenter(Experimenter experimenter, ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        Session session = this.sf.getSession();
        SecureMerge action = new SecureMerge(session);
        Experimenter e = this.copyUser(experimenter);
        if (this.isIgnoreCaseLookup()) {
            e.setOmeName(e.getOmeName().toLowerCase());
        }
        e.getDetails().copy(this.sec.newTransientDetails((IObject)e));
        e = (Experimenter)this.sec.doAction(action, (IObject[])new Experimenter[]{e});
        session.flush();
        this.linkGroupAndUser(defaultGroup, e, false);
        if (null != otherGroups) {
            for (ExperimenterGroup group : otherGroups) {
                this.linkGroupAndUser(group, e, false);
            }
        }
        return e.getId();
    }

    @Override
    public void setDefaultGroup(Experimenter user, ExperimenterGroup group) {
        ExperimenterGroup foundGroup;
        Session session = this.sf.getSession();
        Experimenter foundUser = this.userById(user.getId(), session);
        Set foundMaps = foundUser.findGroupExperimenterMap(foundGroup = this.groupById(group.getId(), session));
        if (foundMaps.size() < 1) {
            throw new ApiUsageException("Group " + group.getId() + " was not found for user " + user.getId());
        }
        if (foundMaps.size() > 1) {
            log.warn(foundMaps.size() + " copies of " + foundGroup + " found for " + foundUser);
        } else {
            GroupExperimenterMap newDef = (GroupExperimenterMap)foundMaps.iterator().next();
            log.info(String.format("Changing default group for user %s to %s", foundUser.getId(), group.getId()));
            foundUser.setPrimaryGroupExperimenterMap(newDef);
        }
        this.sec.doAction(new SecureMerge(session), (IObject[])new Experimenter[]{foundUser});
    }

    @Override
    public void setGroupOwner(Experimenter user, ExperimenterGroup group, boolean value) {
        ExperimenterGroup foundGroup;
        Session session = this.sf.getSession();
        Experimenter foundUser = this.userById(user.getId(), session);
        Set foundMaps = foundUser.findGroupExperimenterMap(foundGroup = this.groupById(group.getId(), session));
        if (foundMaps.size() < 1) {
            throw new ApiUsageException("Group " + group.getId() + " was not found for user " + user.getId());
        }
        if (foundMaps.size() > 1) {
            log.warn(foundMaps.size() + " copies of " + foundGroup + " found for " + foundUser);
        } else {
            GroupExperimenterMap newDef = (GroupExperimenterMap)foundMaps.iterator().next();
            log.info(String.format("Seeting ownership flag on user %s to %s for %s", foundUser.getId(), value, group.getId()));
            newDef.setOwner(Boolean.valueOf(value));
            this.sec.doAction(new SecureMerge(session), (IObject[])new GroupExperimenterMap[]{newDef});
        }
    }

    @Override
    public void addGroups(Experimenter user, ExperimenterGroup ... groups) {
        Session session = this.sf.getSession();
        ArrayList<String> added = new ArrayList<String>();
        Experimenter foundUser = this.userById(user.getId(), session);
        for (ExperimenterGroup group : groups) {
            ExperimenterGroup foundGroup = this.groupById(group.getId(), session);
            boolean found = false;
            for (ExperimenterGroup currentGroup : foundUser.linkedExperimenterGroupList()) {
                found |= HibernateUtils.idEqual((IObject)foundGroup, (IObject)currentGroup);
            }
            if (found) continue;
            this.linkGroupAndUser(foundGroup, foundUser, false);
            added.add(foundGroup.getName());
        }
        this.fixDefaultGroup(foundUser, session);
    }

    @Override
    public void removeGroups(Experimenter user, ExperimenterGroup ... groups) {
        final Session session = this.sf.getSession();
        Experimenter foundUser = this.userById(user.getId(), session);
        ArrayList<Long> toRemove = new ArrayList<Long>();
        ArrayList<String> removed = new ArrayList<String>();
        for (ExperimenterGroup g : groups) {
            if (g.getId() == null) continue;
            toRemove.add(g.getId());
        }
        for (GroupExperimenterMap map : foundUser.collectGroupExperimenterMap(null)) {
            Long pId = map.parent().getId();
            Long cId = map.child().getId();
            if (!toRemove.contains(pId)) continue;
            ExperimenterGroup p = this.groupById(pId, session);
            Experimenter c = this.userById(cId, session);
            p.unlinkExperimenter(c);
            this.sec.doAction(new SecureAction(){

                @Override
                public <T extends IObject> T updateObject(T ... objs) {
                    for (T t : objs) {
                        session.delete(t);
                    }
                    session.flush();
                    return null;
                }
            }, (IObject[])new GroupExperimenterMap[]{map});
            removed.add(p.getName());
        }
        this.fixDefaultGroup(foundUser, session);
        session.flush();
    }

    @Override
    public boolean isIgnoreCaseLookup() {
        return this.ignoreCaseLookup.get();
    }

    protected GroupExperimenterMap linkGroupAndUser(ExperimenterGroup group, Experimenter e, boolean owned) {
        if (group == null || group.getId() == null) {
            throw new ApiUsageException("Group must be persistent.");
        }
        group = new ExperimenterGroup(group.getId(), false);
        for (GroupExperimenterMap link : e.unmodifiableGroupExperimenterMap()) {
            ExperimenterGroup test = link.parent();
            if (!test.getId().equals(group.getId())) continue;
            return link;
        }
        GroupExperimenterMap link = e.linkExperimenterGroup(group);
        link.setOwner(Boolean.valueOf(owned));
        link.getDetails().copy(this.sec.newTransientDetails((IObject)link));
        Session session = this.sf.getSession();
        this.sec.doAction(new SecureMerge(session), new IObject[]{this.userById(e.getId(), session), link});
        session.flush();
        return link;
    }

    protected Experimenter copyUser(Experimenter e) {
        if (e.getOmeName() == null) {
            throw new ValidationException("OmeName may not be null.");
        }
        Experimenter copy = new Experimenter();
        copy.setOmeName(e.getOmeName());
        copy.setFirstName(e.getFirstName());
        copy.setMiddleName(e.getMiddleName());
        copy.setLastName(e.getLastName());
        copy.setEmail(e.getEmail());
        copy.setInstitution(e.getInstitution());
        copy.setLdap(e.getLdap());
        copy.setConfig(e.getConfig());
        if (e.getDetails() != null && e.getDetails().getPermissions() != null) {
            copy.getDetails().setPermissions(e.getDetails().getPermissions());
        }
        return copy;
    }

    protected ExperimenterGroup copyGroup(ExperimenterGroup g) {
        if (g.getName() == null) {
            throw new ValidationException("Group name may not be null.");
        }
        ExperimenterGroup copy = new ExperimenterGroup();
        copy.setDescription(g.getDescription());
        copy.setName(g.getName());
        copy.setLdap(g.getLdap());
        copy.setConfig(g.getConfig());
        copy.getDetails().copy(this.sec.newTransientDetails((IObject)g));
        copy.getDetails().setPermissions(g.getDetails().getPermissions());
        return copy;
    }

    private ExperimenterGroup groupByName(String name, Session s) {
        Query q = s.createQuery("select g from ExperimenterGroup g where g.name = :name");
        q.setParameter("name", (Object)name);
        ExperimenterGroup g = (ExperimenterGroup)q.uniqueResult();
        return g;
    }

    private Experimenter userById(long id, Session s) {
        return (Experimenter)s.load(Experimenter.class, (Serializable)Long.valueOf(id));
    }

    private ExperimenterGroup groupById(long id, Session s) {
        return (ExperimenterGroup)s.load(ExperimenterGroup.class, (Serializable)Long.valueOf(id));
    }

    private void fixDefaultGroup(Experimenter u, Session s) {
        ExperimenterGroup g = this.shouldBeDefault(u, s);
        if (g != null) {
            this.setDefaultGroup(u, g);
        }
    }

    private ExperimenterGroup shouldBeDefault(Experimenter usr, Session s) {
        String USER;
        List grps = usr.linkedExperimenterGroupList();
        if (grps.size() >= 2 && (USER = this.sec.getSecurityRoles().getUserGroupName()).equals(((ExperimenterGroup)grps.get(0)).getName())) {
            return (ExperimenterGroup)grps.get(1);
        }
        return null;
    }
}

