/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.parameters.Parameters;
import ome.services.messages.ContextMessage;
import ome.system.OmeroContext;
import ome.util.messages.InternalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PerGroupActor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerGroupActor.class);
    private final OmeroContext applicationContext;
    private final IQuery queryService;
    private final Long currentGroupId;

    PerGroupActor(OmeroContext applicationContext, IQuery queryService, Long currentGroupId) {
        this.applicationContext = applicationContext;
        this.queryService = queryService;
        this.currentGroupId = currentGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actOnByGroup(Collection<Long> pixelsIds) {
        if (pixelsIds.isEmpty()) {
            return;
        }
        HashMultimap pixelsByGroup = HashMultimap.create();
        for (Object[] objectArray : this.queryService.projection("SELECT id, details.group.id FROM Pixels WHERE id IN (:ids)", new Parameters().addIds(pixelsIds))) {
            Long pixelsId = (Long)objectArray[0];
            Long groupId = (Long)objectArray[1];
            pixelsByGroup.put((Object)groupId, (Object)pixelsId);
        }
        for (Map.Entry entry : pixelsByGroup.asMap().entrySet()) {
            Long groupId = (Long)entry.getKey();
            if (groupId.equals(this.currentGroupId)) {
                this.actOnOneGroup((Set)entry.getValue());
                continue;
            }
            HashMap<String, String> groupContext = new HashMap<String, String>();
            groupContext.put("omero.group", Long.toString(groupId));
            try {
                try {
                    this.applicationContext.publishMessage((InternalMessage)new ContextMessage.Push(this, groupContext));
                }
                catch (Throwable t) {
                    LOGGER.error("could not publish context change push", t);
                }
                this.actOnOneGroup((Set)entry.getValue());
            }
            finally {
                try {
                    this.applicationContext.publishMessage((InternalMessage)new ContextMessage.Pop(this, groupContext));
                }
                catch (Throwable t) {
                    LOGGER.error("could not publish context change pop", t);
                }
            }
        }
    }

    protected abstract void actOnOneGroup(Set<Long> var1);
}

