/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import com.google.common.collect.MapMaker;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.annotations.RolesAllowed;
import ome.api.IPixels;
import ome.api.IRepositoryInfo;
import ome.api.RawPixelsStore;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.ResourceError;
import ome.conditions.RootException;
import ome.conditions.ValidationException;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.io.nio.RomioPixelBuffer;
import ome.io.nio.TileSizes;
import ome.model.IObject;
import ome.model.core.Channel;
import ome.model.core.Pixels;
import ome.parameters.Parameters;
import ome.services.AbstractStatefulBean;
import ome.util.PixelData;
import ome.util.ShallowCopy;
import ome.util.SqlAction;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.metadata.StatsFactory;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class RawPixelsBean
extends AbstractStatefulBean
implements RawPixelsStore {
    private static Logger log = LoggerFactory.getLogger(RawPixelsBean.class);
    private static final long serialVersionUID = -6640632220587930165L;
    private static final int DEFAULT_HISTOGRAM_BINSIZE = 256;
    private Long id;
    private transient Long reset = null;
    private transient Pixels pixelsInstance;
    private transient PixelBuffer buffer;
    private transient PixelsService dataService;
    private transient IPixels metadataService;
    private transient IRepositoryInfo iRepositoryInfo;
    private transient boolean diskSpaceChecking;
    private transient byte[] readBuffer;
    private transient Map<Long, Pixels> pixelsCache;
    private transient SqlAction sql;
    private TileSizes tileSizes;

    public RawPixelsBean() {
    }

    public RawPixelsBean(boolean checking, String omeroDataDir) {
        this.diskSpaceChecking = checking;
    }

    public void setTileSizes(TileSizes tileSizes) {
        this.tileSizes = tileSizes;
    }

    public synchronized Class<? extends ServiceInterface> getServiceInterface() {
        return RawPixelsStore.class;
    }

    public final synchronized void setPixelsMetadata(IPixels metaService) {
        this.getBeanHelper().throwIfAlreadySet(this.metadataService, metaService);
        this.metadataService = metaService;
    }

    public final synchronized void setPixelsData(PixelsService dataService) {
        this.getBeanHelper().throwIfAlreadySet(this.dataService, dataService);
        this.dataService = dataService;
    }

    public final synchronized void setIRepositoryInfo(IRepositoryInfo iRepositoryInfo) {
        this.getBeanHelper().throwIfAlreadySet(this.iRepositoryInfo, iRepositoryInfo);
        this.iRepositoryInfo = iRepositoryInfo;
    }

    public final synchronized void setSqlAction(SqlAction sql) {
        this.getBeanHelper().throwIfAlreadySet(this.sql, sql);
        this.sql = sql;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public synchronized void passivate() {
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public synchronized void activate() {
        if (this.id != null) {
            this.reset = this.id;
            this.id = null;
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public synchronized Pixels save() {
        if (this.isModified()) {
            Long id;
            Long l = id = this.pixelsInstance == null ? null : this.pixelsInstance.getId();
            if (id == null) {
                return null;
            }
            try {
                byte[] hash = this.buffer.calculateMessageDigest();
                this.pixelsInstance.setSha1(Hex.encodeHexString((byte[])hash));
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof FileNotFoundException) {
                    String msg = "Cannot find path. Deleted? " + this.buffer;
                    log.warn(msg);
                    this.clean();
                    throw new ResourceError(msg);
                }
                throw re;
            }
            catch (IOException e) {
                log.warn("calculateMessageDigest failed on " + this.buffer, (Throwable)e);
                throw new ResourceError(e.getMessage());
            }
            this.iUpdate.flush();
            this.modified = false;
            return (Pixels)new ShallowCopy().copy((IObject)this.pixelsInstance);
        }
        return null;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public synchronized void close() {
        try {
            this.save();
        }
        catch (RootException root) {
            throw root;
        }
        catch (RuntimeException re) {
            Long id = this.pixelsInstance == null ? null : this.pixelsInstance.getId();
            log.error("Failed to update pixels: " + id, (Throwable)re);
        }
        finally {
            this.clean();
        }
    }

    public synchronized void clean() {
        this.dataService = null;
        this.pixelsInstance = null;
        try {
            this.closePixelBuffer();
        }
        finally {
            this.buffer = null;
            this.readBuffer = null;
            this.pixelsCache = null;
        }
    }

    private synchronized void closePixelBuffer() {
        try {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer could not be closed successfully.", (Throwable)e);
            }
            throw new ResourceError(e.getMessage() + " Please check server log.");
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized void setPixelsId(long pixelsId, boolean bypassOriginalFile) {
        if (this.id == null || this.id != pixelsId) {
            this.id = pixelsId;
            this.pixelsInstance = null;
            this.closePixelBuffer();
            this.buffer = null;
            this.reset = null;
            this.pixelsInstance = this.pixelsCache != null && this.pixelsCache.containsKey(pixelsId) ? this.pixelsCache.get(pixelsId) : (Pixels)this.iQuery.findByQuery("select p from Pixels as p join fetch p.pixelsType left outer join fetch p.channels as c left outer join fetch c.logicalChannel as lc left outer join fetch c.statsInfo where p.id = :id", new Parameters().addId(this.id));
            if (this.pixelsInstance == null) {
                throw new ValidationException("Cannot read pixels id=" + this.id);
            }
            try {
                this.buffer = this.dataService.getPixelBuffer(this.pixelsInstance, true);
            }
            catch (RuntimeException re) {
                this.id = null;
                throw re;
            }
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized long getPixelsId() {
        this.errorIfNotLoaded();
        return this.id;
    }

    @RolesAllowed(value={"user"})
    public String getPixelsPath() {
        this.errorIfNotLoaded();
        return this.buffer.getPath();
    }

    @RolesAllowed(value={"user"})
    public synchronized void prepare(Set<Long> pixelsIds) {
        this.pixelsCache = new MapMaker().makeMap();
        List pixelsList = this.iQuery.findAllByQuery("select p from Pixels as p join fetch p.pixelsType where p.id in (:ids)", new Parameters().addIds(pixelsIds));
        for (Pixels pixels : pixelsList) {
            this.pixelsCache.put(pixels.getId(), pixels);
        }
    }

    private synchronized void errorIfNotLoaded() {
        if (this.reset != null) {
            this.id = null;
            this.setPixelsId(this.reset, false);
            this.reset = null;
        }
        if (this.buffer == null) {
            throw new ApiUsageException("This RawPixelsStore has not been properly initialized.\nPlease set the pixels id before executing any other methods.\n");
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] calculateMessageDigest() {
        this.errorIfNotLoaded();
        try {
            return this.buffer.calculateMessageDigest();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) {
        this.errorIfNotLoaded();
        int cubeSize = RomioPixelBuffer.safeLongToInteger((Long)this.buffer.getHypercubeSize(offset, size, step));
        if (this.readBuffer == null || this.readBuffer.length != cubeSize) {
            this.readBuffer = new byte[cubeSize];
        }
        try {
            this.readBuffer = this.buffer.getHypercubeDirect(offset, size, step, this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getPlaneRegion(int z, int c, int t, int count, int offset) {
        this.errorIfNotLoaded();
        int size = RomioPixelBuffer.safeLongToInteger((Long)((long)this.buffer.getByteWidth() * (long)count));
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getPlaneRegionDirect(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), Integer.valueOf(count), Integer.valueOf(offset), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getPlane(int arg0, int arg1, int arg2) {
        this.errorIfNotLoaded();
        int size = RomioPixelBuffer.safeLongToInteger((Long)this.buffer.getPlaneSize());
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getPlaneDirect(Integer.valueOf(arg0), Integer.valueOf(arg1), Integer.valueOf(arg2), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized long getPlaneOffset(int arg0, int arg1, int arg2) {
        this.errorIfNotLoaded();
        try {
            return this.buffer.getPlaneOffset(Integer.valueOf(arg0), Integer.valueOf(arg1), Integer.valueOf(arg2));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized long getPlaneSize() {
        this.errorIfNotLoaded();
        return this.buffer.getPlaneSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public synchronized byte[] getRegion(int arg0, long arg1) {
        this.errorIfNotLoaded();
        PixelData pd = null;
        byte[] bytes = null;
        try {
            pd = this.buffer.getRegion(Integer.valueOf(arg0), Long.valueOf(arg1));
            bytes = this.bufferAsByteArrayWithExceptionIfNull(pd.getData());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (pd != null) {
                pd.dispose();
            }
        }
        return bytes;
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getRow(int arg0, int arg1, int arg2, int arg3) {
        this.errorIfNotLoaded();
        int size = this.buffer.getRowSize();
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getRowDirect(Integer.valueOf(arg0), Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getCol(int arg0, int arg1, int arg2, int arg3) {
        this.errorIfNotLoaded();
        int size = this.buffer.getColSize();
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getColDirect(Integer.valueOf(arg0), Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized long getRowOffset(int arg0, int arg1, int arg2, int arg3) {
        this.errorIfNotLoaded();
        try {
            return this.buffer.getRowOffset(Integer.valueOf(arg0), Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized int getRowSize() {
        this.errorIfNotLoaded();
        return this.buffer.getRowSize();
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getStack(int arg0, int arg1) {
        this.errorIfNotLoaded();
        int size = RomioPixelBuffer.safeLongToInteger((Long)this.buffer.getStackSize());
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getStackDirect(Integer.valueOf(arg0), Integer.valueOf(arg1), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized long getStackOffset(int arg0, int arg1) {
        this.errorIfNotLoaded();
        try {
            return this.buffer.getStackOffset(Integer.valueOf(arg0), Integer.valueOf(arg1));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized long getStackSize() {
        this.errorIfNotLoaded();
        return this.buffer.getStackSize();
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getTimepoint(int arg0) {
        this.errorIfNotLoaded();
        int size = RomioPixelBuffer.safeLongToInteger((Long)this.buffer.getTimepointSize());
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getTimepointDirect(Integer.valueOf(arg0), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized long getTimepointOffset(int arg0) {
        this.errorIfNotLoaded();
        try {
            return this.buffer.getTimepointOffset(Integer.valueOf(arg0));
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized long getTimepointSize() {
        this.errorIfNotLoaded();
        return this.buffer.getTimepointSize();
    }

    @RolesAllowed(value={"user"})
    public synchronized long getTotalSize() {
        this.errorIfNotLoaded();
        return this.buffer.getTotalSize();
    }

    @RolesAllowed(value={"user"})
    public synchronized int getByteWidth() {
        this.errorIfNotLoaded();
        return this.buffer.getByteWidth();
    }

    @RolesAllowed(value={"user"})
    public synchronized boolean isSigned() {
        this.errorIfNotLoaded();
        return this.buffer.isSigned();
    }

    @RolesAllowed(value={"user"})
    public synchronized boolean isFloat() {
        this.errorIfNotLoaded();
        return this.buffer.isFloat();
    }

    @RolesAllowed(value={"user"})
    public synchronized void setPlane(byte[] arg0, int arg1, int arg2, int arg3) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            this.buffer.setPlane(arg0, Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3));
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized void setRegion(int arg0, long arg1, byte[] arg2) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            this.buffer.setRegion(Integer.valueOf(arg0), Long.valueOf(arg1), arg2);
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized void setRow(byte[] arg0, int arg1, int arg2, int arg3, int arg4) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            ByteBuffer buf = ByteBuffer.wrap(arg0);
            this.buffer.setRow(buf, Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3), Integer.valueOf(arg4));
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized void setStack(byte[] arg0, int arg1, int arg2, int arg3) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            this.buffer.setStack(arg0, Integer.valueOf(arg1), Integer.valueOf(arg2), Integer.valueOf(arg3));
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized void setTimepoint(byte[] arg0, int arg1) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            this.buffer.setTimepoint(arg0, Integer.valueOf(arg1));
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @RolesAllowed(value={"user"})
    public synchronized Map<Integer, int[]> getHistogram(int[] channels, int binCount, boolean globalRange, PlaneDef plane) {
        this.errorIfNotLoaded();
        int resolutionLevel = -1;
        int i = 0;
        while (i < this.buffer.getResolutionLevels()) {
            if (this.buffer.getResolutionLevels() > 1) {
                this.buffer.setResolutionLevel(i);
            }
            if (this.buffer.getSizeX() > this.tileSizes.getMaxPlaneWidth() || this.buffer.getSizeY() > this.tileSizes.getMaxPlaneHeight()) break;
            resolutionLevel = i++;
        }
        if (resolutionLevel < 0) {
            throw new ApiUsageException("All resolution levels larger than max plane size");
        }
        if (this.buffer.getResolutionLevels() > 1) {
            this.buffer.setResolutionLevel(resolutionLevel);
        }
        if (binCount <= 0) {
            binCount = 256;
        }
        int imgWidth = this.buffer.getSizeX();
        int z = plane != null && plane.getZ() >= 0 ? plane.getZ() : 0;
        int t = plane != null && plane.getT() >= 0 ? plane.getT() : 0;
        int x = plane != null && plane.getRegion() != null && plane.getRegion().getX() >= 0 ? plane.getRegion().getX() : 0;
        int y = plane != null && plane.getRegion() != null && plane.getRegion().getY() >= 0 ? plane.getRegion().getY() : 0;
        int w = plane != null && plane.getRegion() != null && plane.getRegion().getWidth() > 0 ? plane.getRegion().getWidth() : imgWidth;
        int h = plane != null && plane.getRegion() != null && plane.getRegion().getHeight() > 0 ? plane.getRegion().getHeight() : this.buffer.getSizeY();
        HashMap<Integer, int[]> result = new HashMap<Integer, int[]>();
        try {
            for (int ch : channels) {
                Channel channel = this.pixelsInstance.getChannel(ch);
                if (channel == null) continue;
                PixelData px = this.buffer.getPlane(Integer.valueOf(z), Integer.valueOf(ch), Integer.valueOf(t));
                int[] data = new int[binCount];
                double[] minmax = this.determineHistogramMinMax(px, channel, globalRange);
                double min = minmax[0];
                double max = minmax[1];
                double range = max - min;
                double binRange = range / (double)binCount;
                for (int i2 = 0; i2 < px.size(); ++i2) {
                    int pxx = i2 % imgWidth;
                    int pxy = i2 / imgWidth;
                    if (pxx < x || pxx >= x + w || pxy < y || pxy >= y + h || px.getPixelValue(i2) < min || px.getPixelValue(i2) > max) continue;
                    int bin = (int)((px.getPixelValue(i2) - min) / binRange);
                    if (bin == binCount) {
                        // empty if block
                    }
                    int n = --bin;
                    data[n] = data[n] + 1;
                }
                result.put(ch, data);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    @RolesAllowed(value={"user"})
    public synchronized Map<Integer, double[]> findMinMax(int[] channels) {
        HashMap<Integer, double[]> result = new HashMap<Integer, double[]>();
        if (this.requiresPixelsPyramid()) {
            return result;
        }
        try {
            for (int ch : channels) {
                Channel channel = this.pixelsInstance.getChannel(ch);
                if (channel == null) continue;
                int z = this.buffer.getSizeZ() > 1 ? (this.buffer.getSizeZ() - 1) / 2 : 0;
                int t = this.buffer.getSizeT() > 1 ? (this.buffer.getSizeT() - 1) / 2 : 0;
                PixelData px = this.buffer.getPlane(Integer.valueOf(z), Integer.valueOf(ch), Integer.valueOf(t));
                double[] minmax = this.determineHistogramMinMax(px, channel, false);
                result.put(ch, minmax);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return result;
    }

    private double[] determineHistogramMinMax(PixelData px, Channel channel, boolean useGlobal) {
        double max;
        double min;
        if (useGlobal && channel != null && channel.getStatsInfo() != null) {
            min = channel.getStatsInfo().getGlobalMin();
            max = channel.getStatsInfo().getGlobalMax();
            if (max != 1.0) {
                return new double[]{min, max};
            }
        }
        StatsFactory sf = new StatsFactory();
        double[] pixelMinMax = sf.initPixelsRange(channel.getPixels());
        min = pixelMinMax[1];
        max = pixelMinMax[0];
        for (int i = 0; i < px.size(); ++i) {
            min = Math.min(min, px.getPixelValue(i));
            max = Math.max(max, px.getPixelValue(i));
        }
        return new double[]{min, max};
    }

    private synchronized byte[] bufferAsByteArrayWithExceptionIfNull(ByteBuffer buffer) {
        byte[] b = new byte[buffer.capacity()];
        buffer.get(b, 0, buffer.capacity());
        return b;
    }

    private synchronized void handleException(Exception e) {
        if (e instanceof RootException) {
            throw (RootException)((Object)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Error handling pixels.", (Throwable)e);
        }
        if (e instanceof IOException) {
            throw new ResourceError(e.getMessage());
        }
        if (e instanceof DimensionsOutOfBoundsException) {
            throw new ApiUsageException(e.getMessage());
        }
        if (e instanceof BufferUnderflowException) {
            throw new ResourceError("BufferUnderflowException: " + e.getMessage());
        }
        if (e instanceof BufferOverflowException) {
            throw new ResourceError("BufferOverflowException: " + e.getMessage());
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public synchronized boolean isDiskSpaceChecking() {
        return this.diskSpaceChecking;
    }

    public synchronized void setDiskSpaceChecking(boolean diskSpaceChecking) {
        this.diskSpaceChecking = diskSpaceChecking;
    }

    @RolesAllowed(value={"user"})
    public synchronized int getResolutionLevels() {
        this.errorIfNotLoaded();
        return this.buffer.getResolutionLevels();
    }

    @RolesAllowed(value={"user"})
    public synchronized List<List<Integer>> getResolutionDescriptions() {
        this.errorIfNotLoaded();
        return this.buffer.getResolutionDescriptions();
    }

    @RolesAllowed(value={"user"})
    public synchronized int[] getTileSize() {
        this.errorIfNotLoaded();
        Dimension tileSize = this.buffer.getTileSize();
        return new int[]{(int)tileSize.getWidth(), (int)tileSize.getHeight()};
    }

    @RolesAllowed(value={"user"})
    public synchronized boolean requiresPixelsPyramid() {
        this.errorIfNotLoaded();
        return this.dataService.requiresPixelsPyramid(this.pixelsInstance);
    }

    @RolesAllowed(value={"user"})
    public synchronized int getResolutionLevel() {
        this.errorIfNotLoaded();
        return this.buffer.getResolutionLevel();
    }

    @RolesAllowed(value={"user"})
    public synchronized void setResolutionLevel(int resolutionLevel) {
        this.errorIfNotLoaded();
        this.buffer.setResolutionLevel(resolutionLevel);
    }

    @RolesAllowed(value={"user"})
    public synchronized byte[] getTile(int z, int c, int t, int x, int y, int w, int h) {
        this.errorIfNotLoaded();
        int size = RomioPixelBuffer.safeLongToInteger((Long)((long)w * (long)h * (long)this.buffer.getByteWidth()));
        if (this.readBuffer == null || this.readBuffer.length != size) {
            this.readBuffer = new byte[size];
        }
        try {
            this.readBuffer = this.buffer.getTileDirect(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), Integer.valueOf(x), Integer.valueOf(y), Integer.valueOf(w), Integer.valueOf(h), this.readBuffer);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.readBuffer;
    }

    @RolesAllowed(value={"user"})
    public synchronized void setTile(byte[] data, int z, int c, int t, int x, int y, int w, int h) {
        this.errorIfNotLoaded();
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            this.buffer.setTile(data, Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t), Integer.valueOf(x), Integer.valueOf(y), Integer.valueOf(w), Integer.valueOf(h));
            this.modified();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

