/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.sql.SQLException;
import ome.parameters.Parameters;
import ome.services.query.Definitions;
import ome.services.query.Query;
import ome.services.query.QueryParameterDef;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class PojosGetImagesByOptionsQueryDefinition
extends Query {
    static Definitions defs = new Definitions(new QueryParameterDef[0]);

    public PojosGetImagesByOptionsQueryDefinition(Parameters parameters) {
        super(defs, parameters);
    }

    @Override
    protected void buildQuery(Session session) throws HibernateException, SQLException {
        QueryBuilder qb = new QueryBuilder();
        qb.select("img");
        qb.from("Image", "img");
        qb.join("img.details.creationEvent", "ce", true, true);
        qb.join("img.details.updateEvent", "ue", true, true);
        qb.join("img.pixels", "pix", true, true);
        qb.join("img.format", "format", true, true);
        qb.join("pix.pixelsType", "pt", true, true);
        qb.join("img.annotationLinksCountPerOwner", "i_c_ann", true, true);
        if (this.params.isAcquisitionData()) {
            qb.join("img.stageLabel", "position", true, true);
            qb.join("img.imagingEnvironment", "condition", true, true);
            qb.join("img.objectiveSettings", "os", true, true);
            qb.join("os.medium", "me", true, true);
            qb.join("os.objective", "objective", true, true);
            qb.join("objective.immersion", "im", true, true);
            qb.join("objective.correction", "co", true, true);
        }
        qb.where();
        if (this.params.getStartTime() != null) {
            qb.and("img.details.creationEvent.time > :starttime");
            qb.param("starttime", (Object)this.params.getStartTime());
        }
        if (this.params.getEndTime() != null) {
            qb.and("img.details.creationEvent.time < :endtime");
            qb.param("endtime", (Object)this.params.getEndTime());
        }
        this.setQuery(qb.query(session));
    }

    @Override
    protected void enableFilters(Session session) {
        this.ownerOrGroupFilters(session, new String[]{"image_owner_filter"}, new String[]{"image_group_filter"});
    }
}

