/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import Ice.Communicator;
import Ice.InputStream;
import Ice.OutputStream;
import Ice.Util;
import java.lang.reflect.Method;

public class IceUtil {
    private static final Object ICE_ENCODING;
    private static final Method ICE_OUTPUT_STREAM_METHOD;
    private static final Method ICE_INPUT_STREAM_METHOD;

    public static OutputStream createSafeOutputStream(Communicator ic) {
        Object[] args = ICE_ENCODING != null ? new Object[]{ic, ICE_ENCODING} : new Object[]{ic};
        try {
            return (OutputStream)ICE_OUTPUT_STREAM_METHOD.invoke(null, args);
        }
        catch (Exception e) {
            throw new RuntimeException("ICE_INPUT_STREAM_METHOD failed", e);
        }
    }

    public static InputStream createSafeInputStream(Communicator ic, byte[] data) {
        Object[] args = ICE_ENCODING != null ? new Object[]{ic, data, ICE_ENCODING} : new Object[]{ic, data};
        try {
            return (InputStream)ICE_INPUT_STREAM_METHOD.invoke(null, args);
        }
        catch (Exception e) {
            throw new RuntimeException("ICE_INPUT_STREAM_METHOD failed", e);
        }
    }

    static {
        Class<Communicator> ic = Communicator.class;
        Class<byte[]> b = byte[].class;
        Method os = null;
        Method is = null;
        Object enc = null;
        try {
            try {
                Class<?> ev = Class.forName("Ice.EncodingVersion");
                os = Util.class.getMethod("createOutputStream", ic, ev);
                is = Util.class.getMethod("createInputStream", ic, b, ev);
                enc = Util.class.getField("Encoding_1_0").get(null);
            }
            catch (ClassNotFoundException e) {
                os = Util.class.getMethod("createOutputStream", ic);
                is = Util.class.getMethod("createInputStream", ic, b);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot configure Ice", e);
        }
        ICE_ENCODING = enc;
        ICE_OUTPUT_STREAM_METHOD = os;
        ICE_INPUT_STREAM_METHOD = is;
    }
}

