/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.tm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.test.tm.SimpleJtaTransactionImpl;
import org.hibernate.test.tm.SimpleJtaTransactionManagerImpl;

public class ConnectionProviderImpl
implements ConnectionProvider {
    private static ConnectionProvider actualConnectionProvider = ConnectionProviderFactory.newConnectionProvider();
    private boolean isTransactional;

    public static ConnectionProvider getActualConnectionProvider() {
        return actualConnectionProvider;
    }

    public void configure(Properties props) throws HibernateException {
    }

    public Connection getConnection() throws SQLException {
        SimpleJtaTransactionImpl currentTransaction = SimpleJtaTransactionManagerImpl.getInstance().getCurrentTransaction();
        if (currentTransaction == null) {
            this.isTransactional = false;
            return actualConnectionProvider.getConnection();
        }
        this.isTransactional = true;
        Connection connection = currentTransaction.getEnlistedConnection();
        if (connection == null) {
            connection = actualConnectionProvider.getConnection();
            currentTransaction.enlistConnection(connection);
        }
        return connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (!this.isTransactional) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        actualConnectionProvider.close();
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

