/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;

public class URLProblems
extends BytecodeScanningDetector {
    static final String[] BAD_SIGNATURES = new String[]{"Hashtable<Ljava/net/URL", "Map<Ljava/net/URL", "Set<Ljava/net/URL"};
    private final BugReporter bugReporter;
    private final BugAccumulator accumulator;
    OpcodeStack stack = new OpcodeStack();

    public URLProblems(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void visitAfter(JavaClass obj) {
        this.accumulator.reportAccumulatedBugs();
    }

    public void visit(Signature obj) {
        String sig = obj.getSignature();
        String[] arr$ = BAD_SIGNATURES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            if (sig.indexOf(s) < 0) continue;
            if (this.visitingField()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
                continue;
            }
            if (this.visitingMethod()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod((PreorderVisitor)this));
                continue;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClass((PreorderVisitor)this).addClass((PreorderVisitor)this));
        }
    }

    public void visit(Method method) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    void check(String className, Pattern name, int target, int url) {
        if (!name.matcher(this.getNameConstantOperand()).matches()) {
            return;
        }
        if (this.stack.getStackDepth() <= target) {
            return;
        }
        OpcodeStack.Item targetItem = this.stack.getStackItem(target);
        OpcodeStack.Item urlItem = this.stack.getStackItem(url);
        if (!urlItem.getSignature().equals("Ljava/net/URL;")) {
            return;
        }
        if (!targetItem.getSignature().equals(className)) {
            return;
        }
        this.accumulator.accumulateBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 182 || seen == 185) {
            this.check("Ljava/util/HashSet;", Pattern.compile("add|remove|contains"), 1, 0);
            this.check("Ljava/util/HashMap;", Pattern.compile("remove|containsKey|get"), 1, 0);
            this.check("Ljava/util/HashMap;", Pattern.compile("put"), 2, 1);
        }
        if (seen == 182 && this.getClassConstantOperand().equals("java/net/URL") && (this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") || this.getNameConstantOperand().equals("hashCode") && this.getSigConstantOperand().equals("()I"))) {
            this.accumulator.accumulateBug(new BugInstance((Detector)this, "DMI_BLOCKING_METHODS_ON_URL", 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

