/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import application.Application;
import application.ApplicationActionMap;
import application.ApplicationContext;
import application.ResourceMap;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.LoadRecentAction;
import org.jhotdraw.gui.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentOrientedApplication
extends Application
implements DocumentOrientedApplication {
    private boolean isExtensionVisible;
    private LinkedList<DocumentView> views = new LinkedList();
    private boolean isEnabled = true;
    private LinkedList<File> recentFiles = new LinkedList();
    private static final int maxRecentFilesCount = 10;
    private Preferences prefs;
    private ResourceMap resourceMap;
    public static final String PROP_VIEW_COUNT = "viewCount";
    public static final String PROP_CURRENT_VIEW = "currentView";

    public static <T extends AbstractDocumentOrientedApplication> void launch(Class<T> applicationClass, String[] args) {
        AbstractDocumentOrientedApplication.initAWT(args);
        Application.launch(applicationClass, (String[])args);
    }

    public static void initAWT(String[] args) {
    }

    @Override
    public void initialize(String[] args) {
        this.initDefaults();
    }

    protected void initDefaults() {
        this.initRecentFiles();
        this.initActionMap();
        this.initLookAndFeel();
        this.initMainFrame();
    }

    protected void initMainFrame() {
    }

    protected void initRecentFiles() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        int count = this.prefs.getInt("recentFileCount", 0);
        for (int i = 0; i < count; ++i) {
            String path = this.prefs.get("recentFile." + i, null);
            if (path == null) continue;
            this.recentFiles.add(new File(path));
        }
    }

    protected void initActionMap() {
        ActionMap am = this.createActionMap();
        if (am != null) {
            ApplicationActionMap acam = ApplicationContext.getInstance().getActionMap();
            for (Object key : am.keys()) {
                acam.put(key, am.get(key));
            }
        }
    }

    protected void initLookAndFeel() {
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    @Override
    public void startup() {
        final DocumentView v = this.createView();
        this.add(v);
        v.setEnabled(false);
        v.execute(new Worker(){

            public Object construct() {
                try {
                    v.clear();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object result) {
                v.setEnabled(true);
            }
        });
        this.show(v);
    }

    @Override
    public void shutdown() {
        for (DocumentView v : new LinkedList(this.getViews())) {
            this.remove(v);
        }
        super.shutdown();
    }

    protected ActionMap createActionMap() {
        return new ActionMap();
    }

    @Override
    public Action getAction(Object key) {
        return ApplicationContext.getInstance().getActionMap().get(key);
    }

    @Override
    public final DocumentView createView() {
        try {
            return (DocumentView)this.getViewClass().newInstance();
        }
        catch (IllegalAccessException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
        catch (InstantiationException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }

    public abstract Class getViewClass();

    protected void initView(DocumentView v) {
        v.init();
    }

    protected void destroyView(DocumentView v) {
        v.destroy();
    }

    protected LinkedList<JToolBar> createToolBars(DocumentView v) {
        LinkedList<JToolBar> l = new LinkedList<JToolBar>();
        return l;
    }

    protected JMenuBar createMenuBar(DocumentView v, List<Action> toolBarActions) {
        JMenuBar mb = new JMenuBar();
        for (JMenu mm : this.createMenus(v)) {
            if (mm == null) continue;
            mb.add(mm);
        }
        return mb;
    }

    protected LinkedList<JMenu> createMenus(DocumentView v) {
        LinkedList<JMenu> l = new LinkedList<JMenu>();
        JMenu m = this.createFileMenu(v);
        if (null != m) {
            l.add(m);
        }
        if (null != (m = this.createEditMenu(v))) {
            l.add(m);
        }
        if (null != (m = this.createViewMenu(v))) {
            l.add(m);
        }
        if (null != (m = this.createWindowMenu(v))) {
            l.add(m);
        }
        if (null != (m = this.createHelpMenu(v))) {
            l.add(m);
        }
        return l;
    }

    protected JMenu createFileMenu(DocumentView v) {
        return null;
    }

    protected void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new LoadRecentAction(f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    protected JMenu createEditMenu(DocumentView v) {
        ResourceMap labels = this.getFrameworkResourceMap();
        JMenu m = new JMenu();
        m.setName("Edit.Menu");
        labels.injectComponent((Component)m);
        JMenuItem mi = m.add(v != null ? v.getAction("Edit.undo") : this.getAction("Edit.undo"));
        mi.setIcon(null);
        mi = m.add(v != null ? v.getAction("Edit.redo") : this.getAction("Edit.redo"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("Edit.cut"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.copy"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.paste"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.duplicate"));
        mi.setIcon(null);
        mi = m.add(this.getAction("Edit.delete"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("Edit.selectAll"));
        mi.setIcon(null);
        if (this.getAction("Edit.find") != null) {
            m.addSeparator();
            m.add(this.getAction("Edit.find"));
        }
        return m;
    }

    protected JMenu createViewMenu(DocumentView v) {
        return null;
    }

    protected JMenu createWindowMenu(DocumentView v) {
        return null;
    }

    protected JMenu createHelpMenu(DocumentView v) {
        return null;
    }

    @Override
    public void add(DocumentView v) {
        int oldCount = this.views.size();
        this.views.add(v);
        this.initView(v);
        this.firePropertyChange(PROP_VIEW_COUNT, oldCount, this.views.size());
    }

    @Override
    public void remove(DocumentView v) {
        this.hide(v);
        int oldCount = this.views.size();
        this.views.remove(v);
        this.destroyView(v);
        this.firePropertyChange(PROP_VIEW_COUNT, oldCount, this.views.size());
    }

    public List<DocumentView> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    @Override
    public abstract void show(DocumentView var1);

    @Override
    public abstract void hide(DocumentView var1);

    @Override
    public abstract DocumentView getCurrentView();

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.isEnabled;
        this.isEnabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    @Override
    public abstract boolean isEditorShared();

    @Override
    public List<File> recentFiles() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    @Override
    public void clearRecentFiles() {
        List oldValue = (List)this.recentFiles.clone();
        this.recentFiles.clear();
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void addRecentFile(File file) {
        List oldValue = (List)this.recentFiles.clone();
        if (this.recentFiles.contains(file)) {
            this.recentFiles.remove(file);
        }
        this.recentFiles.addFirst(file);
        if (this.recentFiles.size() > 10) {
            this.recentFiles.removeLast();
        }
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        int i = 0;
        for (File f : this.recentFiles) {
            this.prefs.put("recentFile." + i, f.getPath());
            ++i;
        }
        this.firePropertyChange("recentFiles", oldValue, 0);
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void addPalette(Window w) {
    }

    @Override
    public void removePalette(Window w) {
    }

    public void updateName(DocumentView v) {
        boolean success;
        String baseName;
        ResourceMap labels = this.getFrameworkResourceMap();
        if (v.getFile() == null) {
            baseName = labels.getString("File.unnamedFile", new Object[0]);
        } else {
            int p;
            baseName = v.getFile().getName();
            if (!this.isExtensionVisible && (p = baseName.lastIndexOf(46)) != -1) {
                baseName = baseName.substring(0, p);
            }
        }
        String name = baseName;
        if (name == null || name.startsWith("null")) {
            new Throwable().printStackTrace();
        }
        int count = 1;
        block0: do {
            success = true;
            for (DocumentView vv : this.getViews()) {
                if (vv == v || vv.getName() == null || !vv.getName().equals(name)) continue;
                name = baseName + " " + ++count;
                success = false;
                continue block0;
            }
        } while (!success);
        v.setName(name);
    }

    protected ResourceMap getResourceMap() {
        if (this.resourceMap == null) {
            return ApplicationContext.getInstance().getResourceMap(this.getViewClass());
        }
        return this.resourceMap;
    }

    protected ResourceMap getFrameworkResourceMap() {
        return ApplicationContext.getInstance().getResourceMap(AbstractDocumentOrientedApplication.class);
    }
}

