/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import jj2000.j2k.decoder.Grib2JpegDecoder;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2DataSection {
    private int length;
    private final int section;
    private float[] data;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int scanMode;
    private int count;
    private int Xlength;

    public Grib2DataSection(boolean getData, RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        if (!getData) {
            if (this.length > 0 && (long)this.length < raf.length()) {
                raf.skipBytes(this.length - 5);
            } else {
                this.length = 5;
            }
            return;
        }
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 0 || dtn == 1) {
            this.simpleUnpacking(raf, gds, drs, bms);
        } else if (dtn == 2) {
            this.complexUnpacking(raf, gds, drs);
        } else if (dtn == 3) {
            this.complexUnpackingWithSpatial(raf, gds, drs);
        } else if (dtn == 40 || dtn == 40000) {
            this.jpeg2000Unpacking(raf, gds, drs, bms);
        }
    }

    private void simpleUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 1) {
            System.out.println("DS Matrix values not supported yet");
            return;
        }
        int dataPoints = drs.getDataPoints();
        float pmv = drs.getPrimaryMissingValue();
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        int numberPoints = gds.getNumberPoints();
        this.data = new float[numberPoints];
        boolean[] bitmap = bms.getBitmap();
        if (bitmap == null) {
            for (int i = 0; i < numberPoints; ++i) {
                this.data[i] = (R + (float)this.bits2UInt(nb, raf) * EE) / DD;
            }
        } else {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (int i = 0; i < bitmap.length; ++i) {
                this.data[i] = bitmap[i] ? (R + (float)this.bits2UInt(nb, raf) * EE) / DD : pmv;
            }
        }
        this.scanMode = gds.getScanMode();
        this.Xlength = gds.getNx();
        this.scanningModeCheck();
    }

    private void complexUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs) throws IOException {
        int X2;
        int j;
        int mvm = drs.getMissingValueManagement();
        float pmv = drs.getPrimaryMissingValue();
        int NG = drs.getNumberOfGroups();
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            X1[i] = this.bits2UInt(nb, raf);
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            NB[i] = this.bits2UInt(nb, raf);
        }
        int[] L = new int[NG];
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            L[i] = ref + this.bits2UInt(nb, raf) * len_inc;
        }
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[gds.getNumberPoints()];
        this.count = 0;
        this.Xlength = gds.getNx();
        int[] bitsmv1 = new int[31];
        for (int i = 0; i < 31; ++i) {
            bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG - 1; ++i) {
            for (j = 0; j < L[i]; ++j) {
                if (NB[i] == 0) {
                    if (mvm == 0) {
                        this.data[this.count++] = (R + (float)X1[i] * EE) / DD;
                        continue;
                    }
                    if (mvm != 1) continue;
                    this.data[this.count++] = pmv;
                    continue;
                }
                X2 = this.bits2UInt(NB[i], raf);
                if (mvm == 0) {
                    this.data[this.count++] = (R + (float)(X1[i] + X2) * EE) / DD;
                    continue;
                }
                if (mvm != 1) continue;
                this.data[this.count++] = X2 == bitsmv1[NB[i]] ? pmv : (R + (float)(X1[i] + X2) * EE) / DD;
            }
        }
        int last = drs.getLengthLastGroup();
        for (j = 0; j < last; ++j) {
            if (NB[NG - 1] == 0) {
                if (mvm == 0) {
                    this.data[this.count++] = (R + (float)X1[NG - 1] * EE) / DD;
                    continue;
                }
                if (mvm != 1) continue;
                this.data[this.count++] = pmv;
                continue;
            }
            X2 = this.bits2UInt(NB[NG - 1], raf);
            if (mvm == 0) {
                this.data[this.count++] = (R + (float)(X1[NG - 1] + X2) * EE) / DD;
                continue;
            }
            if (mvm != 1) continue;
            this.data[this.count++] = X2 == bitsmv1[NB[NG - 1]] ? pmv : (R + (float)(X1[NG - 1] + X2) * EE) / DD;
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private void complexUnpackingWithSpatial(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs) throws IOException {
        int idx;
        int X2;
        int j;
        int sign;
        int mvm = drs.getMissingValueManagement();
        float pmv = drs.getPrimaryMissingValue();
        int NG = drs.getNumberOfGroups();
        int g1 = 0;
        int gMin = 0;
        int h1 = 0;
        int h2 = 0;
        int hMin = 0;
        int os = drs.getOrderSpatial();
        int ds = drs.getDescriptorSpatial();
        this.bitPos = 0;
        this.bitBuf = 0;
        ds = ds * 8 - 1;
        if (os == 1) {
            sign = this.bits2UInt(1, raf);
            g1 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                g1 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            gMin = this.bits2UInt(ds, raf);
            if (sign == 1) {
                gMin *= -1;
            }
        } else if (os == 2) {
            sign = this.bits2UInt(1, raf);
            h1 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                h1 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            h2 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                h2 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            hMin = this.bits2UInt(ds, raf);
            if (sign == 1) {
                hMin *= -1;
            }
        } else {
            System.out.println("DS error os=" + os + " ds =" + ds);
            return;
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            X1[i] = this.bits2UInt(nb, raf);
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            NB[i] = this.bits2UInt(nb, raf);
        }
        int[] L = new int[NG];
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            L[i] = ref + this.bits2UInt(nb, raf) * len_inc;
        }
        this.data = new float[gds.getNumberPoints()];
        int[] bitsmv1 = new int[31];
        for (int i = 0; i < 31; ++i) {
            bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
        this.count = 0;
        this.Xlength = gds.getNx();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG - 1; ++i) {
            for (j = 0; j < L[i]; ++j) {
                if (NB[i] == 0) {
                    if (mvm == 0) {
                        this.data[this.count++] = X1[i];
                        continue;
                    }
                    if (mvm != 1) continue;
                    this.data[this.count++] = pmv;
                    continue;
                }
                X2 = this.bits2UInt(NB[i], raf);
                if (mvm == 0) {
                    this.data[this.count++] = X1[i] + X2;
                    continue;
                }
                if (mvm != 1) continue;
                this.data[this.count++] = X2 == bitsmv1[NB[i]] ? pmv : (float)(X1[i] + X2);
            }
        }
        int last = drs.getLengthLastGroup();
        for (j = 0; j < last; ++j) {
            if (NB[NG - 1] == 0) {
                if (mvm == 0) {
                    this.data[this.count++] = X1[NG - 1];
                    continue;
                }
                if (mvm != 1) continue;
                this.data[this.count++] = pmv;
                continue;
            }
            X2 = this.bits2UInt(NB[NG - 1], raf);
            if (mvm == 0) {
                this.data[this.count++] = X1[NG - 1] + X2;
                continue;
            }
            if (mvm != 1) continue;
            this.data[this.count++] = X2 == bitsmv1[NB[NG - 1]] ? pmv : (float)(X1[NG - 1] + X2);
        }
        if (os == 1) {
            float sum = 0.0f;
            if (mvm == 0) {
                int i = 1;
                while (i < this.data.length) {
                    int n = i++;
                    this.data[n] = this.data[n] + (float)gMin;
                }
                this.data[0] = g1;
                for (i = 1; i < this.data.length; ++i) {
                    this.data[i] = this.data[i - 1] + (sum += this.data[i]);
                }
            } else {
                int i;
                float lastOne = pmv;
                idx = 0;
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == pmv) continue;
                    if (idx == 0) {
                        this.data[i] = g1;
                        lastOne = this.data[i];
                        idx = i + 1;
                        continue;
                    }
                    int n = i;
                    this.data[n] = this.data[n] + (float)gMin;
                }
                if (lastOne == pmv) {
                    System.out.println("DS bad spatial differencing data");
                    return;
                }
                for (i = idx; i < this.data.length; ++i) {
                    if (this.data[i] == pmv) continue;
                    this.data[i] = lastOne + (sum += this.data[i]);
                    lastOne = this.data[i];
                }
            }
        } else if (os == 2) {
            float hDiff = h2 - h1;
            float sum = 0.0f;
            if (mvm == 0) {
                int i = 2;
                while (i < this.data.length) {
                    int n = i++;
                    this.data[n] = this.data[n] + (float)hMin;
                }
                this.data[0] = h1;
                this.data[1] = h2;
                sum = hDiff;
                for (i = 2; i < this.data.length; ++i) {
                    this.data[i] = this.data[i - 1] + (sum += this.data[i]);
                }
            } else {
                int i;
                idx = 0;
                float lastOne = pmv;
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == pmv) continue;
                    if (idx == 0) {
                        this.data[i] = h1;
                        sum = 0.0f;
                        lastOne = this.data[i];
                        ++idx;
                        continue;
                    }
                    if (idx == 1) {
                        this.data[i] = (float)h1 + hDiff;
                        sum = hDiff;
                        lastOne = this.data[i];
                        idx = i + 1;
                        continue;
                    }
                    int n = i;
                    this.data[n] = this.data[n] + (float)hMin;
                }
                if (lastOne == pmv) {
                    System.out.println("DS bad spatial differencing data");
                    return;
                }
                for (i = idx; i < this.data.length; ++i) {
                    if (this.data[i] == pmv) continue;
                    this.data[i] = lastOne + (sum += this.data[i]);
                    lastOne = this.data[i];
                }
            }
        }
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        if (mvm == 0) {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (R + this.data[i] * EE) / DD;
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == pmv) continue;
                this.data[i] = (R + this.data[i] * EE) / DD;
            }
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private void jpeg2000Unpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) {
        int dataPoints = drs.getDataPoints();
        float pmv = drs.getPrimaryMissingValue();
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        Grib2JpegDecoder g2j = null;
        if (nb != 0) {
            String[] argv = new String[]{"-rate", Integer.toString(nb), "-verbose", "off"};
            g2j = new Grib2JpegDecoder(argv);
            g2j.decode(raf, this.length - 5);
        }
        int numberPoints = gds.getNumberPoints();
        this.data = new float[numberPoints];
        boolean[] bitmap = bms.getBitmap();
        if (bitmap == null) {
            if (nb == 0) {
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = pmv;
                }
            } else {
                if (g2j.data.length != numberPoints) {
                    this.data = null;
                    return;
                }
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = (R + (float)g2j.data[i] * EE) / DD;
                }
            }
        } else {
            int j = 0;
            for (int i = 0; i < bitmap.length; ++i) {
                this.data[i] = bitmap[i] ? (R + (float)g2j.data[j++] * EE) / DD : pmv;
            }
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private void scanningModeCheck() {
        if (this.scanMode == 0 || this.scanMode == 64) {
            return;
        }
        if (this.scanMode == 128 || this.scanMode == 192) {
            int mid = this.Xlength / 2;
            for (int index = 0; index < this.data.length; index += this.Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = this.data[index + idx];
                    this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                    this.data[index + this.Xlength - idx - 1] = tmp;
                }
            }
            return;
        }
        int mid = this.Xlength / 2;
        for (int index = 0; index < this.data.length; index += this.Xlength) {
            int row = index / this.Xlength;
            if (row % 2 != 1) continue;
            for (int idx = 0; idx < mid; ++idx) {
                float tmp = this.data[index + idx];
                this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                this.data[index + this.Xlength - idx - 1] = tmp;
            }
        }
    }

    public final float[] getData() {
        return this.data;
    }
}

