/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    private String pluginId;
    private String provider;
    private String website;
    private String shortDescription;
    private ArrayList<DetectorFactory> detectorFactoryList;
    private ArrayList<BugPattern> bugPatternList;
    private ArrayList<BugCode> bugCodeList;
    private boolean enabled;
    private ArrayList<DetectorOrderingConstraint> interPassConstraintList;
    private ArrayList<DetectorOrderingConstraint> intraPassConstraintList;

    public Plugin(String pluginId) {
        this.pluginId = pluginId;
        this.detectorFactoryList = new ArrayList();
        this.bugPatternList = new ArrayList();
        this.bugCodeList = new ArrayList();
        this.interPassConstraintList = new ArrayList();
        this.intraPassConstraintList = new ArrayList();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void addDetectorFactory(DetectorFactory factory) {
        this.detectorFactoryList.add(factory);
    }

    public void addBugPattern(BugPattern bugPattern) {
        this.bugPatternList.add(bugPattern);
    }

    public void addBugCode(BugCode bugCode) {
        this.bugCodeList.add(bugCode);
    }

    public void addInterPassOrderingConstraint(DetectorOrderingConstraint constraint) {
        this.interPassConstraintList.add(constraint);
    }

    public void addIntraPassOrderingConstraint(DetectorOrderingConstraint constraint) {
        this.intraPassConstraintList.add(constraint);
    }

    public DetectorFactory getFactoryByShortName(final String shortName) {
        return this.chooseFactory(new FactoryChooser(){

            public boolean choose(DetectorFactory factory) {
                return factory.getShortName().equals(shortName);
            }
        });
    }

    public DetectorFactory getFactoryByFullName(final String fullName) {
        return this.chooseFactory(new FactoryChooser(){

            public boolean choose(DetectorFactory factory) {
                return factory.getFullName().equals(fullName);
            }
        });
    }

    public Iterator<DetectorFactory> detectorFactoryIterator() {
        return this.detectorFactoryList.iterator();
    }

    public Iterator<BugPattern> bugPatternIterator() {
        return this.bugPatternList.iterator();
    }

    public Iterator<BugCode> bugCodeIterator() {
        return this.bugCodeList.iterator();
    }

    public Iterator<DetectorOrderingConstraint> interPassConstraintIterator() {
        return this.interPassConstraintList.iterator();
    }

    public Iterator<DetectorOrderingConstraint> intraPassConstraintIterator() {
        return this.intraPassConstraintList.iterator();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    private DetectorFactory chooseFactory(FactoryChooser chooser) {
        Iterator<DetectorFactory> i = this.detectorFactoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = i.next();
            if (!chooser.choose(factory)) continue;
            return factory;
        }
        return null;
    }

    private static interface FactoryChooser {
        public boolean choose(DetectorFactory var1);
    }
}

