/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.Token;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.BitSet;

public class Tokenizer {
    private static final BitSet whiteSpace = new BitSet();
    private static final BitSet single;
    private PushbackReader reader;

    public Tokenizer(Reader reader) {
        this.reader = new PushbackReader(reader);
    }

    public Token next() throws IOException {
        this.skipWhitespace();
        int c = this.reader.read();
        if (c < 0) {
            return new Token(-1);
        }
        if (c == 10) {
            return new Token(-2);
        }
        if (c == 39 || c == 34) {
            return this.munchString(c);
        }
        if (c == 47) {
            return this.maybeComment();
        }
        if (single.get(c)) {
            return new Token(2, String.valueOf((char)c));
        }
        this.reader.unread(c);
        return this.parseWord();
    }

    private void skipWhitespace() throws IOException {
        int c;
        while ((c = this.reader.read()) >= 0) {
            if (whiteSpace.get(c)) continue;
            this.reader.unread(c);
            break;
        }
    }

    private Token munchString(int delimiter) throws IOException {
        int c;
        boolean SCAN = false;
        boolean ESCAPE = true;
        int DONE = 2;
        StringBuffer result = new StringBuffer();
        result.append((char)delimiter);
        int state = 0;
        while (state != 2 && (c = this.reader.read()) >= 0) {
            result.append((char)c);
            switch (state) {
                case 0: {
                    if (c == delimiter) {
                        state = 2;
                        break;
                    }
                    if (c != 92) break;
                    state = 1;
                    break;
                }
                case 1: {
                    state = 0;
                }
            }
        }
        return new Token(1, result.toString());
    }

    private Token maybeComment() throws IOException {
        int c = this.reader.read();
        if (c == 47) {
            StringBuffer result = new StringBuffer();
            result.append("//");
            while ((c = this.reader.read()) >= 0) {
                if (c == 10) {
                    this.reader.unread(c);
                    break;
                }
                result.append((char)c);
            }
            return new Token(3, result.toString());
        }
        if (c == 42) {
            StringBuffer result = new StringBuffer();
            result.append("/*");
            boolean SCAN = false;
            boolean STAR = true;
            int DONE = 2;
            int state = 0;
            while (state != 2) {
                c = this.reader.read();
                if (c < 0) {
                    state = 2;
                } else {
                    result.append((char)c);
                }
                switch (state) {
                    case 0: {
                        if (c != 42) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (c == 47) {
                            state = 2;
                            break;
                        }
                        if (c == 42) break;
                        state = 0;
                        break;
                    }
                }
            }
            return new Token(3, result.toString());
        }
        if (c >= 0) {
            this.reader.unread(c);
        }
        return new Token(2, "/");
    }

    private Token parseWord() throws IOException {
        int c;
        StringBuffer result = new StringBuffer();
        while ((c = this.reader.read()) >= 0) {
            if (whiteSpace.get(c) || c == 10 || single.get(c)) {
                this.reader.unread(c);
                break;
            }
            result.append((char)c);
        }
        return new Token(0, result.toString());
    }

    static {
        whiteSpace.set(32);
        whiteSpace.set(9);
        whiteSpace.set(13);
        whiteSpace.set(12);
        single = new BitSet();
        single.set(33);
        single.set(37);
        single.set(94);
        single.set(38);
        single.set(42);
        single.set(40);
        single.set(41);
        single.set(45);
        single.set(43);
        single.set(61);
        single.set(91);
        single.set(93);
        single.set(123);
        single.set(125);
        single.set(124);
        single.set(58);
        single.set(59);
        single.set(44);
        single.set(46);
        single.set(60);
        single.set(62);
        single.set(63);
        single.set(126);
    }
}

