/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JStringAttributeField
extends JTextField {
    private static final boolean DEBUG = false;
    private DrawingEditor editor;
    private AttributeKey<String> attributeKey;
    private boolean isMultipleValues;
    protected ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private int isUpdatingField = 0;
    private PropertyChangeListener viewEventHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "enabled") {
                JStringAttributeField.this.updateEnabledState();
            }
        }
    };
    private EditorEventHandler eventHandler = new EditorEventHandler();

    public JStringAttributeField() {
        this(null, null);
    }

    public JStringAttributeField(DrawingEditor editor, AttributeKey<String> attributeKey) {
        this.initComponents();
        this.attributeKey = attributeKey;
        this.setEditor(editor);
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JStringAttributeField.this.updateFigures();
            }

            public void removeUpdate(DocumentEvent e) {
                JStringAttributeField.this.updateFigures();
            }

            public void changedUpdate(DocumentEvent e) {
                JStringAttributeField.this.updateFigures();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JStringAttributeField.this.updateFigures();
            }
        });
    }

    public void setAttributeKey(AttributeKey<String> attributeKey) {
        this.attributeKey = attributeKey;
    }

    public void setEditor(DrawingEditor editor) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.getView() != null) {
                this.getView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = editor;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.eventHandler);
            if (this.getView() != null) {
                this.getView().addFigureSelectionListener(this.eventHandler);
            }
            this.updateEnabledState();
            this.updateField();
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor == null ? null : this.editor.getActiveView();
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    protected void updateField() {
        if (this.isUpdatingField++ == 0) {
            if (this.getView() == null || this.attributeKey == null) {
                this.setText("");
            } else {
                String fieldValue = null;
                boolean isFirst = true;
                this.isMultipleValues = false;
                for (Figure f : this.getView().getSelectedFigures()) {
                    if (isFirst) {
                        isFirst = false;
                        fieldValue = this.attributeKey.get(f);
                        continue;
                    }
                    String figureValue = this.attributeKey.get(f);
                    if (figureValue == fieldValue || figureValue != null && fieldValue != null && figureValue.equals(fieldValue)) continue;
                    fieldValue = null;
                    this.isMultipleValues = true;
                }
                this.setText(fieldValue);
            }
            this.repaint();
        }
        --this.isUpdatingField;
    }

    private void updateFigures() {
        if (this.isUpdatingField++ == 0) {
            String fieldValue = this.getText().trim();
            if (fieldValue.length() == 0) {
                fieldValue = null;
            }
            if (this.getView() != null && this.attributeKey != null) {
                for (Figure f : this.getView().getSelectedFigures()) {
                    this.attributeKey.set(f, fieldValue);
                }
            }
            this.editor.setDefaultAttribute(this.attributeKey, fieldValue);
        }
        --this.isUpdatingField;
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.editor.getActiveView() != null) {
                this.editor.getActiveView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = null;
    }

    private void initComponents() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isFocusOwner() && this.isMultipleValues) {
            Insets insets = this.getInsets();
            Insets margin = this.getMargin();
            int height = this.getHeight();
            FontMetrics fm = g.getFontMetrics(this.getFont());
            g.setFont(this.getFont().deriveFont(2));
            g.drawString(this.labels.getString("multipleValues"), insets.left + margin.left, insets.top + margin.top + fm.getAscent());
        }
    }

    private class EditorEventHandler
    implements PropertyChangeListener,
    FigureSelectionListener {
        private EditorEventHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "activeView") {
                DrawingView view;
                if (evt.getOldValue() != null) {
                    view = (DrawingView)evt.getOldValue();
                    view.removeFigureSelectionListener(this);
                    view.removePropertyChangeListener(JStringAttributeField.this.viewEventHandler);
                }
                if (evt.getNewValue() != null) {
                    view = (DrawingView)evt.getNewValue();
                    view.addFigureSelectionListener(this);
                    view.addPropertyChangeListener(JStringAttributeField.this.viewEventHandler);
                }
                JStringAttributeField.this.updateEnabledState();
                JStringAttributeField.this.updateField();
            } else if (name.equals(JStringAttributeField.this.attributeKey.getKey())) {
                JStringAttributeField.this.updateField();
            }
        }

        public void selectionChanged(FigureSelectionEvent evt) {
            JStringAttributeField.this.updateEnabledState();
            JStringAttributeField.this.updateField();
        }
    }
}

