/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BCDIntField;
import org.apache.solr.schema.BCDLongField;
import org.apache.solr.schema.BCDStrField;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.ByteField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.DoubleField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntField;
import org.apache.solr.schema.LongField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.ShortField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryResponseWriter
implements BinaryQueryResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryResponseWriter.class);
    public static final Set<Class> KNOWN_TYPES = new HashSet<Class>();

    @Override
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        Resolver resolver = new Resolver(req, response.getReturnFields());
        Boolean omitHeader = req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            response.getValues().remove("responseHeader");
        }
        JavaBinCodec codec = new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver);
        codec.marshal((Object)response.getValues(), out);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    @Override
    public void init(NamedList args) {
    }

    public static NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            Resolver resolver = new Resolver(req, rsp.getReturnFields());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).marshal((Object)rsp.getValues(), (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return (NamedList)new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).unmarshal((InputStream)in);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        KNOWN_TYPES.add(BoolField.class);
        KNOWN_TYPES.add(BCDIntField.class);
        KNOWN_TYPES.add(BCDLongField.class);
        KNOWN_TYPES.add(BCDStrField.class);
        KNOWN_TYPES.add(ByteField.class);
        KNOWN_TYPES.add(DateField.class);
        KNOWN_TYPES.add(DoubleField.class);
        KNOWN_TYPES.add(FloatField.class);
        KNOWN_TYPES.add(ShortField.class);
        KNOWN_TYPES.add(IntField.class);
        KNOWN_TYPES.add(LongField.class);
        KNOWN_TYPES.add(SortableLongField.class);
        KNOWN_TYPES.add(SortableIntField.class);
        KNOWN_TYPES.add(SortableFloatField.class);
        KNOWN_TYPES.add(SortableDoubleField.class);
        KNOWN_TYPES.add(StrField.class);
        KNOWN_TYPES.add(TextField.class);
        KNOWN_TYPES.add(TrieField.class);
        KNOWN_TYPES.add(TrieIntField.class);
        KNOWN_TYPES.add(TrieLongField.class);
        KNOWN_TYPES.add(TrieFloatField.class);
        KNOWN_TYPES.add(TrieDoubleField.class);
        KNOWN_TYPES.add(TrieDateField.class);
        KNOWN_TYPES.add(BinaryField.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Resolver
    implements JavaBinCodec.ObjectResolver {
        private final SolrQueryRequest solrQueryRequest;
        private IndexSchema schema;
        private SolrIndexSearcher searcher;
        private final Set<String> returnFields;
        private final boolean includeScore;
        boolean useFieldObjects = true;

        public Resolver(SolrQueryRequest req, Set<String> returnFields) {
            this.solrQueryRequest = req;
            boolean bl = this.includeScore = returnFields != null && returnFields.contains("score");
            if (returnFields != null && (returnFields.size() == 0 || returnFields.size() == 1 && this.includeScore || returnFields.contains("*"))) {
                returnFields = null;
            }
            this.returnFields = returnFields;
        }

        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            if (o instanceof DocList) {
                this.writeDocList((DocList)o, codec);
                return null;
            }
            if (o instanceof SolrDocument) {
                SolrDocument solrDocument = (SolrDocument)o;
                codec.writeSolrDocument(solrDocument, this.returnFields);
                return null;
            }
            if (o instanceof Document) {
                return this.getDoc((Document)o);
            }
            return o;
        }

        public void writeDocList(DocList ids, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)12);
            ArrayList<Number> l = new ArrayList<Number>(3);
            l.add(Long.valueOf(ids.matches()));
            l.add(Long.valueOf(ids.offset()));
            Float maxScore = null;
            if (this.includeScore && ids.hasScores()) {
                maxScore = Float.valueOf(ids.maxScore());
            }
            l.add(maxScore);
            codec.writeArray(l);
            int sz = ids.size();
            codec.writeTag((byte)-128, sz);
            if (this.searcher == null) {
                this.searcher = this.solrQueryRequest.getSearcher();
            }
            if (this.schema == null) {
                this.schema = this.solrQueryRequest.getSchema();
            }
            DocIterator iterator = ids.iterator();
            for (int i = 0; i < sz; ++i) {
                int id = iterator.nextDoc();
                Document doc = this.searcher.doc(id, this.returnFields);
                SolrDocument sdoc = this.getDoc(doc);
                if (this.includeScore && ids.hasScores()) {
                    sdoc.addField("score", (Object)Float.valueOf(iterator.score()));
                }
                codec.writeSolrDocument(sdoc);
            }
        }

        public SolrDocument getDoc(Document doc) {
            SolrDocument solrDoc = new SolrDocument();
            for (Fieldable f : doc.getFields()) {
                Object val;
                String fieldName = f.name();
                if (this.returnFields != null && !this.returnFields.contains(fieldName)) continue;
                SchemaField sf = this.schema.getFieldOrNull(fieldName);
                FieldType ft = null;
                if (sf != null) {
                    ft = sf.getType();
                }
                if (ft == null) {
                    val = f.isBinary() ? f.getBinaryValue() : (Object)f.stringValue();
                } else {
                    try {
                        val = this.useFieldObjects && KNOWN_TYPES.contains(ft.getClass()) ? (Object)ft.toObject(f) : (Object)ft.toExternal(f);
                    }
                    catch (Exception e) {
                        LOG.warn("Error reading a field from document : " + solrDoc, (Throwable)e);
                        continue;
                    }
                }
                if (sf != null && sf.multiValued() && !solrDoc.containsKey((Object)fieldName)) {
                    ArrayList<byte[]> l = new ArrayList<byte[]>();
                    l.add((byte[])val);
                    solrDoc.addField(fieldName, l);
                    continue;
                }
                solrDoc.addField(fieldName, val);
            }
            return solrDoc;
        }
    }
}

